<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');

$routes->get('login', 'LoginController::index', ['as' => 'login']);
$routes->post('login/auth', 'LoginController::auth');
$routes->get('logout', 'LoginController::logout', ['filter' => ['auth']]);

$routes->get('dashboard', 'Home::dashboard', ['filter' => ['auth']]);

$routes->group('configs', ['filter' => ['auth']], static function ($routes) {
    $routes->post('add_tasa', 'ConfigsController::add_tasa');
});

$routes->group('administrador', ['filter' => ['auth']], static function ($routes) {
    $routes->get('/', 'AdministradorController::index');
    $routes->get('listaempresas', 'AdministradorController::listaempresas');
    $routes->get('empresas_list', 'AdministradorController::empresas_list');
    $routes->get('empresas_add', 'AdministradorController::empresas_add');
    $routes->get('empresas_edit', 'AdministradorController::empresas_edit');
    $routes->get('empresas_show/(:num)', 'AdministradorController::empresas_show/$1');

    $routes->post('add_empresas', 'AdministradorController::add_empresas');
    $routes->post('edit_empresas', 'AdministradorController::edit_empresas');
});

$routes->group('clientes', ['filter' => ['auth']], static function ($routes) {
    $routes->get('/', 'ClientesController::index');
    $routes->get('listaclientes', 'ClientesController::listaclientes');
    $routes->get('clientes_list', 'ClientesController::clientes_list');
    $routes->get('clientes_add', 'ClientesController::clientes_add');
    $routes->get('clientes_edit', 'ClientesController::clientes_edit');
    $routes->get('clientes_show/(:num)', 'ClientesController::clientes_show/$1');

    $routes->post('search_clientes', 'ClientesController::search_clientes');
    $routes->post('add_clientes', 'ClientesController::add_clientes');
    $routes->post('edit_clientes', 'ClientesController::edit_clientes');
});

$routes->group('productos', ['filter' => ['auth']], static function ($routes) {
    $routes->get('/', 'ProductosController::index');
    $routes->get('listaproductos', 'ProductosController::listaproductos');
    $routes->get('productos_list', 'ProductosController::productos_list');
    $routes->get('productos_add', 'ProductosController::productos_add');
    $routes->get('productos_edit', 'ProductosController::productos_edit');
    $routes->get('productos_show/(:num)', 'ProductosController::productos_show/$1');

    $routes->post('search_productos', 'ProductosController::search_productos');
    $routes->post('add_productos', 'ProductosController::add_productos');
    $routes->post('edit_productos', 'ProductosController::edit_productos');
});

$routes->group('equipos', ['filter' => ['auth']], static function ($routes) {
    $routes->post('add_equipos', 'EquiposController::add_equipos');
    $routes->post('edit_equipos', 'EquiposController::edit_equipos');
});

$routes->group('ordenes', ['filter' => ['auth',]], static function ($routes) {
    $routes->get('/', 'OrdenesController::index');
    $routes->get('listaordenes', 'OrdenesController::listaordenes');
    $routes->get('listaordenes_id', 'OrdenesController::listaordenes_id');
    $routes->get('ordenes_list', 'OrdenesController::ordenes_list');
    $routes->get('orden_show/(:num)', 'OrdenesController::orden_show/$1');
    $routes->get('ordenes_add_informe/(:num)', 'OrdenesController::ordenes_add_informe/$1');

    $routes->post('add_ordenes', 'OrdenesController::add_ordenes');
    $routes->post('edit_ordenes', 'OrdenesController::edit_ordenes');
});


$routes->group('cotizaciones', ['filter' => ['auth',]], static function ($routes) {
    $routes->get('/', 'CotizacionesController::index');
    $routes->get('listacotizaciones', 'CotizacionesController::listacotizaciones');
    $routes->get('cotizaciones_list', 'CotizacionesController::cotizaciones_list');
    $routes->get('coti_add_id_orden/(:num)', 'CotizacionesController::coti_add_id_orden/$1');    
    $routes->get('coti_add_id_cliente/(:num)', 'CotizacionesController::coti_add_id_cliente/$1');
    $routes->get('listacotizaciones_ar/(:num)', 'CotizacionesController::listacotizaciones_ar/$1');
    $routes->get('listatotales_id/(:num)', 'CotizacionesController::listatotales_id/$1');
    
    $routes->post('add_cotizaciones', 'CotizacionesController::add_cotizaciones');
    $routes->post('edit_cotizaciones', 'CotizacionesController::edit_cotizaciones');
});

$routes->group('nde', ['filter' => ['auth',]], static function ($routes) {
    $routes->get('/', 'NdeController::index');
    $routes->get('listande', 'NdeController::listande');
    $routes->get('nde_list', 'NdeController::nde_list');    
    $routes->get('coti_nde_add/(:num)', 'NdeController::cotizaciones_nde_add/$1');
    
    $routes->post('add_nde', 'NdeController::add_nde');
    $routes->post('edit_nde', 'NdeController::edit_nde');
});

$routes->group('compras', ['filter' => ['auth',]], static function ($routes) {
    $routes->get('/', 'ComprasController::index');
    $routes->get('listacompras', 'ComprasController::listacompras');
    $routes->get('compras_list', 'ComprasController::compras_list');
    $routes->get('coti_compras_add/(:num)', 'ComprasController::cotizaciones_compras_add/$1');
    
    $routes->post('add_compras', 'ComprasController::add_compras');
});

$routes->group('ventas', ['filter' => ['auth',]], static function ($routes) {
    $routes->get('/', 'VentasController::index');
    $routes->get('listaventas', 'VentasController::listaventas');
    $routes->get('ventas_list', 'VentasController::ventas_list');
    $routes->get('coti_ventas_add/(:num)', 'VentasController::cotizaciones_ventas_add/$1');
    
    $routes->post('add_ventas', 'VentasController::add_ventas');
});

$routes->group('caja', ['filter' => ['auth']], static function ($routes) {
    $routes->get('/', 'CajaController::index');
    $routes->get('caja_add_id_nde/(:num)', 'CajaController::caja_add_id_nde/$1');
    $routes->post('add_caja', 'CajaController::add_caja');
});

$routes->group('imprimir', static function ($routes) {
    $routes->get('/', 'ImprmirController::index');
    $routes->get('imprimir_nde/(:num)', 'ImprimirController::imprimir_nde/$1');
    $routes->get('imprimir_cotizacion/(:num)', 'ImprimirController::imprimir_cotizacion/$1');
});


