<?php

namespace App\Controllers;
use app\Config\Images;

use App\Models\EmpresasModel;

class AdministradorController extends BaseController
{
    public function __construct()
    {
        helper(["url", "form", "session", "epscolor"]);
        $this->epsconfig_lib = new \App\Libraries\EpsConfig_Lib();

        $this->empresas = new EmpresasModel();  
    }

    public function index(): string
    {
        $data['dataConfig'] = $this->epsconfig_lib->getData();
        return view ('administrador/index', $data);
    }

    public function empresas_list(): string
    {
        $data['dataConfig'] = $this->epsconfig_lib->getData();

        $data['tablaurl'] = 'administrador/listaempresas';
        return view ('administrador/empresas_list', $data);
    }

    public function empresas_add(): string
    {
        $data['dataConfig'] = $this->epsconfig_lib->getData();
        return view ('administrador/empresas_add', $data);
    }

    public function listaempresas() {
        $respuesta = $this->empresas->get()->getResultArray();
        echo json_encode($respuesta);
    }

    public function add_empresas()
    {
        if ($this->request->getPost()) {
            $rif  = formato_uppercase($this->request->getVar('rif'));
            $razonsocial  = ucwords($this->request->getVar('razonsocial'));

            //$array = ['telefono1' => $telefono1, 'contacto' => $contacto];
            $array = ['rif' => $rif];
            $data = $this->empresas->where($array)->first();

            if ($data) {
                $mensaje = array('mensaje' => 'Rif existe en la base de Datos');
                $success = array('success' => 'add_error');
                $data = array('data' => $data);

                $response = array_merge($data, $mensaje, $success);
            } else {

                $telefono1 = formato_uppercase($this->request->getVar('telefono1'));
                $contacto  = formato_capitalize($this->request->getVar('contacto'));

                $telefono2  = formato_uppercase($this->request->getVar('telefono2'));
                $email  = formato_lowercase($this->request->getVar('email'));
                $direccion  = trim($this->request->getVar('direccion'));
                $activo = $this->request->getVar('check_activo');
                if(isset($activo)) {$activo = '1'; } else {$activo = '0';}


                $session = session();
                $user_name = $session->get('user_name');


                $result = $this->empresas->select('max(id) as maxId')->first();
                $max_id = $result['maxId'];
                $max_id++;

                
                if ( $this->request->getFile('logo')->isValid()) {
                    $imagen = $this->request->getFile('logo');
                    //$imagen_name = $imagen->getClientName();
                    //$foto_type = $foto->getClientMimeType();
                    $imagen_ext = $imagen->guessExtension();
                    //$imagen_name = $max_id . '_' . $rif . '_' . $razonsocial . '.' . $imagen_ext;

                    $imagen_name = 'logo'. '.' .$imagen_ext;
                    //3er parametro true sobreescribe la imagen
                    $imagen->move(ROOTPATH . 'public/assets/epscolor/img/empresas', $imagen_name, true);
                } else {$imagen_name = '';}

                if ( $this->request->getFile('logo2')->isValid()) {
                    $imagen2 = $this->request->getFile('logo2');
                    $imagen2_ext = $imagen2->guessExtension();
                    $imagen2_name = 'logo2'. '.' .$imagen2_ext;
                    //3er parametro true sobreescribe la imagen
                    $imagen2->move(ROOTPATH . 'public/assets/epscolor/img/empresas', $imagen2_name, true);
                } else {$imagen2_name = '';}

                if ( $this->request->getFile('logow')->isValid()) {
                    $imagen3 = $this->request->getFile('logow');
                    $imagen3_ext = $imagen3->guessExtension();
                    $imagen3_name = 'logowhite'. '.' .$imagen3_ext;
                    //3er parametro true sobreescribe la imagen
                    $imagen3->move(ROOTPATH . 'public/assets/epscolor/img/empresas', $imagen3_name, true);
                } else {$imagen3_name = '';}

                
               /* if(!empty($this->request->getFile('logow'))){
                    
                    $validated3 = $this->validateData([], [
                        'logow' => [
                            'uploaded[logow]',
                            'mime_in[logow,image/jpg,image/jpeg,image/gif,image/png]',
                            'max_size[logow,4096]',
                        ],
                    ]);
                    if ($validated3) {
                        $imagen3 = $this->request->getFile('logow');
                        //$imagen_name = $imagen->getClientName();
                        //$foto_type = $foto->getClientMimeType();
                        $imagen3_ext = $imagen3->guessExtension();
                        //$imagen_name = $max_id . '_' . $rif . '_' . $razonsocial . '.' . $imagen_ext;

                        $imagen3_name = 'logowhite'. '.' .$imagen3_ext;
                        //3er parametro true sobreescribe la imagen
                        $imagen3->move(ROOTPATH . 'public/assets/epscolor/img/empresas', $imagen3_name, true);
                    } else {
                        $imagen3_name = '';
                    }
                } */

                $data1 = [
                    "telefono1" => $telefono1,
                    "contacto" => $contacto,
                    "rif" => $rif,
                    "razonsocial" => $razonsocial,
                    "telefono2" => $telefono2,
                    "email" => $email,
                    "direccion" => $direccion,
                    "logo" => $imagen_name,
                    "logo2" => $imagen2_name,
                    "logowhite" => $imagen3_name,
                    "activo" => $activo,
                ];

                $id = $this->empresas->insert($data1);
                $data = $this->empresas->find($id);

                $mensaje = array('mensaje' => 'Empresas almacendado en la base de datos');
                $success = array('success' => 'add_ok');
                $data = array('data' => $data);



                $response = array_merge($data, $mensaje, $success);
            }
        }
        echo json_encode($response);
    }

    public function edit_empresas()
    {
        if ($this->request->getPost()) {
            $id = trim($this->request->getVar('id_empresa'));
            $rif  = formato_uppercase($this->request->getVar('rif'));
            $razonsocial  = ucwords($this->request->getVar('razonsocial'));
            $telefono1 = formato_uppercase($this->request->getVar('telefono1'));
            $contacto  = formato_capitalize($this->request->getVar('contacto'));
            $telefono2  = formato_uppercase($this->request->getVar('telefono2'));
            $email  = formato_lowercase($this->request->getVar('email'));
            $direccion  = trim($this->request->getVar('direccion'));
            $activo = $this->request->getVar('check_activo');
            if(isset($activo)) {$activo = '1'; } else {$activo = '0';}

            $array = ['id' => $id];
            $data = $this->empresas->where($array)->first();
                
            if ( $this->request->getFile('logo')->isValid()) {
                $imagen = $this->request->getFile('logo');
                $imagen_ext = $imagen->guessExtension();
                $imagen_name = 'logo'. '.' .$imagen_ext;
                $imagen->move(ROOTPATH . 'public/assets/epscolor/img/empresas/', $imagen_name, true);
                $image = \Config\Services::image(); 
                $image->withFile(ROOTPATH .'public/assets/epscolor/img/empresas/'.$imagen_name)
                ->resize(90, 70, true, 'width')
                ->save(ROOTPATH .'public/assets/epscolor/img/empresas/'.$imagen_name, true, 10);
            } else {$imagen_name = $data['logo'];}

            if ( $this->request->getFile('logo2')->isValid()) {
                $imagen2 = $this->request->getFile('logo2');
                $imagen2_ext = $imagen2->guessExtension();
                $imagen2_name = 'logo2'. '.' .$imagen2_ext;
                //3er parametro true sobreescribe la imagen
                $imagen2->move(ROOTPATH . 'public/assets/epscolor/img/empresas', $imagen2_name, true);
                $image = \Config\Services::image(); 
                $image->withFile(ROOTPATH .'public/assets/epscolor/img/empresas/'.$imagen2_name)
                ->resize(90, 70, true, 'width')
                ->save(ROOTPATH .'public/assets/epscolor/img/empresas/'.$imagen2_name, true, 10);
            } else {$imagen2_name = $data['logo2'];}

            if ( $this->request->getFile('logow')->isValid()) {
                $imagen3 = $this->request->getFile('logow');
                $imagen3_ext = $imagen3->guessExtension();
                $imagen3_name = 'logowhite'. '.' .$imagen3_ext;
                //3er parametro true sobreescribe la imagen
                $imagen3->move(ROOTPATH . 'public/assets/epscolor/img/empresas', $imagen3_name, true);
                $image = \Config\Services::image(); 
                $image->withFile(ROOTPATH .'public/assets/epscolor/img/empresas/'.$imagen3_name)
                ->resize(90, 70, true, 'width')
                ->save(ROOTPATH .'public/assets/epscolor/img/empresas/'.$imagen3_name, true, 10);
            } else {$imagen3_name = $data['logowhite'];}

            $data1 = [
                "telefono1" => $telefono1,
                "contacto" => $contacto,
                "rif" => $rif,
                "razonsocial" => $razonsocial,
                "telefono2" => $telefono2,
                "email" => $email,
                "direccion" => $direccion,
                "logo" => $imagen_name,
                "logo2" => $imagen2_name,
                "logowhite" => $imagen3_name,
                "activo" => $activo,
            ];
            $id = $this->empresas->update($id, $data1);
            $data = $this->empresas->find($id);

            $mensaje = array('mensaje' => 'Empresas almacendado en la base de datos');
            $success = array('success' => 'add_ok');
            $data = array('data' => $data);

            $response = array_merge($data, $mensaje, $success);
            
        }
        echo json_encode($response);
    }


}