<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;

use App\Models\ClientesModel;
use App\Models\OrdenesModel;
use App\Models\NdeModel;
use App\Models\CajaModel;

class CajaController extends BaseController
{
    public function __construct()
    {
        helper(["url", "form", "session", "epscolor"]);
        $this->epsconfig_lib = new \App\Libraries\EpsConfig_Lib();

        $this->clientes = new ClientesModel();
        $this->nde = new NdeModel();
        $this->ordenes = new OrdenesModel(); 
        $this->caja = new CajaModel();
    }

    public function index()
    {
        //
    }

        public function caja_add_id_nde($id = null)
    {
        $data['dataConfig'] = $this->epsconfig_lib->getData();

        $data['html_documento'] = 'Caja';
        $data['form_doc'] = 'form_add_caja';

        $data['nde'] = $this->nde->find($id);
        $data['cliente'] = $this->clientes->find($data['nde']['id_cliente']);

        if(isset($data['nde']['id_orden'])) {
           $data['orden'] = $this->ordenes->find($data['nde']['id_orden']); 
        }

        $array = ['id_nde' => $id, '' => 1];
        $data = $this->ordenes->where($array)->first();

        return view('caja/caja_add', $data);
    }

    public function add_caja()
    {
        if ($this->request->getPost()) {
            $usuario = session()->get('user_name');

            $id_cliente = trim($this->request->getVar('id_cliente'));
            $id_orden = trim($this->request->getVar('id_orden'));
            if($id_orden){$id_orden = trim($this->request->getVar('id_orden')); } else {$id_orden = null; }

            $id_nde = trim($this->request->getVar('id_nde'));
            if($id_nde){$id_nde = trim($this->request->getVar('id_nde')); } else {$id_nde = null; }
            $id_compra = trim($this->request->getVar('id_compra'));
            if($id_compra){$id_compra = trim($this->request->getVar('id_compra')); } else {$id_compra = null; }
            $id_venta = trim($this->request->getVar('id_venta'));
            if($id_venta){$id_venta = trim($this->request->getVar('id_venta')); } else {$id_venta = null; }

            $categoria = formato_capitalize($this->request->getVar('categoria'));
            $asiento = formato_capitalize($this->request->getVar('asiento'));
            $concepto = ucwords($this->request->getVar('notas'));

            $monto_d = trim($this->request->getVar('monto_d'));
            $monto_bs = trim($this->request->getVar('monto_bs'));
            $tasa = trim($this->request->getVar('tasa'));
            $fecha_emision = trim($this->request->getVar('fecha_emision'));
            $banco = formato_capitalize($this->request->getVar('banco'));
            $ref = formato_uppercase($this->request->getVar('ref'));
            $forma_pago = formato_capitalize($this->request->getVar('forma_pago'));
            $pago_total = $this->request->getPost('check_pago_total');
            if(isset($pago_total)) {$pago_total = '1'; $total_d = '0'; }

            
            $total_d = $monto_d -

            $data1 = [
                "id_cliente" => $id_cliente,
                "id_orden" => $id_orden,
                "id_nde" => $id_nde,
                "id_compra" => $id_compra,
                "id_venta" => $id_venta,

                "monto_d" => $monto_d,
                "monto_bs" => $monto_bs,
                "tasa" => $tasa,

                "asiento" => $asiento,
                "categoria" => $categoria,
                "concepto" => $concepto,
                "fecha_emision" => $fecha_emision,
                "banco" => $banco,
                "ref" => $ref,
                "forma_pago" => $forma_pago,
                "pago_total" => $pago_total,
                "total_d" => $total_d,
                "usuario" => $usuario,
            ];

            $id_caja = $this->caja->insert($data1);
            $data1 = $this->caja->find($id_caja);

            if ($data1) {

                if ((isset($id_nde)) && (!empty($id_nde))) {
                    $data4 = array(
                        'estado' => 'Cobrada',
                    );
                    $this->nde->update($id_nde, $data4);
                }


                $data = array('data' => $data1);
                $success = array('success' => 'add_ok');
                $mensaje = array('mensaje' => 'Datos almacenados en Base Datos');
                $response = array_merge($mensaje, $success, $data);
            }

            /*$mensaje = array('mensaje' => 'Cliente almacendado en la base de datos');
            $success = array('success' => 'add_ok');
            //$data = array ('data' => $data);

            $response = array_merge($data, $mensaje, $success);*/
        }
        echo json_encode($response);
    }
}
