<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;

use App\Models\ConfigsModel;
use App\Models\ClientesModel;
use App\Models\OrdenesModel;

use App\Models\CotizacionesModel;
use App\Models\CotizacionesarticulosModel;

class CotizacionesController extends BaseController
{
    public function __construct()
    {
        helper(["url", "form", "session", "epscolor"]);
        $this->epsconfig_lib = new \App\Libraries\EpsConfig_Lib();

        $this->configs = new ConfigsModel();
        $this->clientes = new ClientesModel();
        $this->ordenes = new OrdenesModel();
        $this->cotizaciones = new CotizacionesModel();
        $this->cotizacionesarticulos = new CotizacionesarticulosModel(); 
    }

    public function index()
    {
        //
    }

    public function listacotizaciones() {
        $respuesta = $this->cotizaciones->orderBy('id', 'desc')->get()->getResultArray();
        echo json_encode($respuesta);
    }

    public function cotizaciones_list(): string
    {
        $data['dataConfig'] = $this->epsconfig_lib->getData();

        $data['tablaurl'] = 'cotizaciones/listacotizaciones';
        return view ('cotizaciones/cotizaciones_list', $data);
    }

    public function coti_add_id_orden($id = null)
    {
        $data['dataConfig'] = $this->epsconfig_lib->getData();

        $data['html_documento'] = 'Cotizacion';
        $data['form_doc'] = 'form_add_cotizaciones';

        $data['post'] = $this->ordenes->find($id);
        $data['cliente'] = $this->clientes->find($data['post']['id_cliente']);

        $data['iva'] = $this->configs->select('id, iva')->get()->getResult();

        return view('cotizaciones/cotizaciones_add', $data);
    }

    public function coti_add_id_cliente($id = null)
    {
        $data['dataConfig'] = $this->epsconfig_lib->getData();

        $data['html_documento'] = 'Cotizacion';
        $data['form_doc'] = 'form_add_cotizaciones';

        //$data['post'] = $this->clientes->find($id);
        $data['cliente'] = $this->clientes->find($id);

        $data['iva'] = $this->configs->select('id, iva')->get()->getResult();

        return view('cotizaciones/cotizaciones_add', $data);
    }

    public function add_cotizaciones()
    {
        if ($this->request->getPost()) {
            $usuario = session()->get('user_name');

            $json_ar = $this->request->getVar("data_ar");
            $Array_ar = json_decode($json_ar, true);

            $json_arto = $this->request->getVar("data_arto");
            $Array_arto = json_decode($json_arto, true);

            $id_cliente = formato_uppercase($this->request->getVar('id_cliente'));
            $id_orden = formato_uppercase($this->request->getVar('id_orden'));
            if($id_orden){$id_orden = formato_uppercase($this->request->getVar('id_orden')); } else {$id_orden = null; }

            $categoria = formato_capitalize($this->request->getVar('categoria'));
            $vendedor = formato_capitalize($this->request->getVar('vendedor'));
            $notas = ucwords($this->request->getVar('notas'));
            $informe = trim($this->request->getVar('informe'));
            if($informe){$informe = trim($this->request->getVar('informe')); } else {$informe = ''; }

            $estado = 'Realizada';

            $data1 = [
                "id_cliente" => $id_cliente,
                "id_orden" => $id_orden,
                              
                "total_d" => $Array_arto[0]['total_d'],
                "subtotal_d" => $Array_arto[0]['subtotal_d'],
                "total_bs" => $Array_arto[0]['total_d'] * $Array_ar[0]['tasa'],
                "subtotal_bs" => $Array_arto[0]['subtotal_d'] * $Array_ar[0]['tasa'],
                "tasa" => $Array_ar[0]['tasa'],
                "iva" => $Array_arto[0]['iva'],

                "estado" => $estado,
                "categoria" => $categoria,
                "notas" => $notas,
                "vendedor" => $vendedor,
                "usuario" => $usuario,
            ];
            $id_cotizacion = $this->cotizaciones->insert($data1);
            $data1 = $this->cotizaciones->find($id_cotizacion);

            if ($data1) {

                $data2 = array();
                $count = count($Array_ar);
                //print_r($count);
                for ($i = 0; $i < $count; $i++) {
                    $data2[] = array(

                        'id_cotizacion' => $id_cotizacion,
                        'id_cliente' => $id_cliente,
                        'id_orden' => $id_orden,
                        'id_producto' => $Array_ar[$i]['id_producto'],

                        'codigo' => $Array_ar[$i]['codigo'],
                        'descripcion' => $Array_ar[$i]['descripcion'],
                        'cantidad' => $Array_ar[$i]['cantidad'],
                        'stock' => $Array_ar[$i]['stock'],
                        
                        'costo_d' => $Array_ar[$i]['costo_d'],
                        'precio_d' => $Array_ar[$i]['precio_d'],
                        'subtotal_d' => $Array_ar[$i]['subtotal_d'],
                        'precio_bs' => $Array_ar[$i]['precio_bs'],
                        'tasa' => $Array_ar[$i]['tasa'],

                        'condicion' => $Array_ar[$i]['condicion'],
                        'categoria' => $Array_ar[$i]['categoria'],

                    );
                }
                $this->cotizacionesarticulos->insertBatch($data2);


                if ((isset($id_orden)) && (!empty($id_orden))) {
                    $data4 = array(
                        'estado' => 'Cotizacion',
                        'informe' => $informe
                    );
                    $this->ordenes->update($id_orden, $data4);
                }

                $data = array('data' => $data1);
                $success = array('success' => 'add_ok');
                $mensaje = array('mensaje' => 'Datos almacenados en Base Datos');
                $response = array_merge($mensaje, $success, $data);
            }

            /*$mensaje = array('mensaje' => 'Cliente almacendado en la base de datos');
            $success = array('success' => 'add_ok');
            //$data = array ('data' => $data);

            $response = array_merge($data, $mensaje, $success);*/
        }
        echo json_encode($response);
    }

    public function edit_cotizaciones()
    {
        if ($this->request->getPost()) {
            $usuario = session()->get('user_name');
            $id = formato_uppercase($this->request->getVar('id_cotizacion'));
            $id_cliente = formato_uppercase($this->request->getVar('id_cliente'));
            $id_orden = formato_uppercase($this->request->getVar('id_orden'));
            if($id_orden){$id_orden = formato_uppercase($this->request->getVar('id_orden')); } else {$id_orden = null; }
            $estado = formato_capitalize($this->request->getVar('estado'));
            $completado = $this->request->getVar('check_completado');
            if(isset($completado)) {$completado = '1'; } else {$completado = '0';}

            $data1 = [
                "id_cliente" => $id_cliente,
                "id_orden" => $id_orden,
                "estado" => $estado,
                "completado" => $completado,
                "usuario" => $usuario,
            ];
            $this->cotizaciones->update($id, $data1);
            $data1 = $this->cotizaciones->find($id);

            if ($data1) {

                if ((isset($id_orden)) && (!empty($id_orden))) {
                    $data4 = array(
                        'estado' => $estado,
                    );
                    $this->ordenes->update($id_orden, $data4);
                }

                $data = array('data' => $data1);
                $success = array('success' => 'add_ok');
                $mensaje = array('mensaje' => 'Datos almacenados en Base Datos');
                $response = array_merge($mensaje, $success, $data);
            }

            /*$mensaje = array('mensaje' => 'Cliente almacendado en la base de datos');
            $success = array('success' => 'add_ok');
            //$data = array ('data' => $data);

            $response = array_merge($data, $mensaje, $success);*/
        }
        echo json_encode($response);
    }

    public function listacotizaciones_ar($id_cotizacion = null) {
        $array = ['id_cotizacion' => $id_cotizacion];
        $respuesta = $this->cotizacionesarticulos->where($array)->get()->getResultArray();

        echo json_encode($respuesta);
    }

    public function listatotales_id($id_cotizacion = null) {
        $array = ['id' => $id_cotizacion];
        $respuesta = $this->cotizaciones->where($array)->get()->getResultArray();

        echo json_encode($respuesta);
    }
}
