<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;

use App\Models\EquiposModel;

class EquiposController extends BaseController
{
    public function __construct()
    {
        helper(["url", "form", "session", "epscolor"]);
        $this->epsconfig_lib = new \App\Libraries\EpsConfig_Lib();

        $this->equipos = new EquiposModel();  
    }

    public function index()
    {

    }

    public function add_equipos()
    {
        if ($this->request->getPost()) {

            $id_cliente = formato_uppercase($this->request->getVar('id_cliente'));

            $modelo = formato_uppercase($this->request->getVar('modelo'));
            $serial  = formato_uppercase($this->request->getVar('serial'));
            $linea  = formato_capitalize($this->request->getVar('linea'));
    
            if($serial != '') {
            //$array = ['serial' => $serial];
            $array = ['id_cliente' => $id_cliente, 'serial' => $serial];
            $data = $this->equipos->where($array)->first(); }

            if (isset($data)) {
                $mensaje = array('mensaje' => 'Serial para este cliente existe en la base de Datos');
                $success = array('success' => 'add_error');
                $data = array('data' => $data);

                $response = array_merge($data, $mensaje, $success);
            } else {

                $data1 = [
                    "id_cliente" => $id_cliente,
                    "modelo" => $modelo,
                    "serial" => $serial,
                    "linea" => $linea,
                ];
                $id = $this->equipos->insert($data1);
                $data = $this->equipos->find($id);

                $mensaje = array('mensaje' => 'Equipo almacendado en la base de datos');
                $success = array('success' => 'add_ok');
                $data = array('data' => $data);

                $response = array_merge($data, $mensaje, $success);
            }
        }
        echo json_encode($response);
    }

    public function edit_equipos()
    {
        if ($this->request->getPost()) {

            $id_equipo = formato_uppercase($this->request->getVar('id_equipo'));
            $id_cliente = formato_uppercase($this->request->getVar('id_cliente'));

            $modelo = formato_uppercase($this->request->getVar('modelo_edit'));
            $serial  = formato_uppercase($this->request->getVar('serial_edit'));
            $linea  = formato_capitalize($this->request->getVar('linea_edit'));

            //$array = ['serial' => $serial];
            $where = ['id' => $id_equipo];
            $data = $this->equipos->where($where)->first();

            if ($data) {
                $data1 = [
                    "id_cliente" => $id_cliente,
                    "modelo" => $modelo,
                    "serial" => $serial,
                    "linea" => $linea,
                ];
                $id = $this->equipos->update($id_equipo, $data1);
                $data = $this->equipos->find($id);

                $mensaje = array('mensaje' => 'Equipo almacendado en la base de datos');
                $success = array('success' => 'add_ok');
                $data = array('data' => $data);

                $response = array_merge($data, $mensaje, $success);
                
            } else {
                $mensaje = array('mensaje' => 'No fue posible actualizar el equipo');
                $success = array('success' => 'edit_error');
                $data = array('data' => $data);

                $response = array_merge($data, $mensaje, $success);
                
            }
        }
        echo json_encode($response);
    }
}
