<?php
namespace App\Controllers;
use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;

use App\Models\ConfigsModel;
use App\Models\ClientesModel;
use App\Models\EquiposModel;
use App\Models\OrdenesModel;
use App\Models\CotizacionesModel;
use App\Models\CotizacionesarticulosModel;
use App\Models\NdeModel;
use App\Models\NdearticulosModel;

//use App\Models\NdeModel;
//use App\Models\NdearticulosModel;

class ImprimirController extends BaseController
{
    public function __construct()
    {
        helper(["url", "form", "session", "epscolor"]);
        $this->epsconfig_lib = new \App\Libraries\EpsConfig_Lib();

        $this->configs = new ConfigsModel();
        $this->clientes = new ClientesModel();        
        $this->equipos = new EquiposModel();        
        $this->ordenes = new OrdenesModel();        
        $this->cotizaciones = new CotizacionesModel();
        $this->cotizacionesarticulos = new CotizacionesarticulosModel();        
        $this->nde = new NdeModel();
        $this->ndearticulos = new NdearticulosModel();

        //$this->nde = new NdeModel();
       // $this->ndearticulos = new NdearticulosModel();

    }
    public function index()
    {
        //
    }
    
   public function imprimir_nde($id = null)
   {
        $data['dataConfig'] = $this->epsconfig_lib->getData();
        $data['iva'] = $this->configs->select('id, iva')->get()->getResult();
        
        $data['html_documento'] = 'Nota de Entrega';
        $data['form_doc'] = 'form_add_nde';
        
        $data['post'] = $this->nde->find($id);
        $data['cliente'] = $this->clientes->find($data['post']['id_cliente']);
        if($data['post']['id_orden'] != null) { $data['orden'] = $this->ordenes->find($data['post']['id_orden']); }
        
        $where = ['id_nde' => $id];
        $data['articulos']  = $this->ndearticulos->where($where)->get()->getResult();
        $data['articulos_totales'] = $data['post'];
        
        
        return view('imprimir/imprimir_nde', $data);
   }
   
    public function imprimir_cotizacion($id = null)
   {
        $data['dataConfig'] = $this->epsconfig_lib->getData();
        $data['iva'] = $this->configs->select('id, iva')->get()->getResult();
        
        $data['html_documento'] = 'Cotizacion';
        $data['form_doc'] = 'form_add_nde';
        
        $data['post'] = $this->cotizaciones->find($id);
        $data['cliente'] = $this->clientes->find($data['post']['id_cliente']);
        if($data['post']['id_orden'] != null) { $data['orden'] = $this->ordenes->find($data['post']['id_orden']); }
        
        $where = ['id_cotizacion' => $id];
        $data['articulos']  = $this->cotizacionesarticulos->where($where)->get()->getResult();
        $data['articulos_totales'] = $data['post'];
        
        
        return view('imprimir/imprimir_cotizacion', $data);
   }
    
}