<?php
namespace App\Controllers;
use CodeIgniter\Controller;
use App\Models\ConfigsModel;
use App\Models\EmpresasModel;
use App\Models\ClientesModel;
class LoginController extends Controller
{
	public function __construct()
	{
		helper(["url", "form"]);
		$this->configs = new ConfigsModel();
		$this->empresas = new EmpresasModel();
		$this->clientes = new ClientesModel();
		$this->epsconfig_lib = new \App\Libraries\EpsConfig_Lib();
	}
	public function index()
	{
		/*$array = ['id' => '1'];
		$data['config'] = $this->config->where($array)->first();
		$data['empresa'] = $this->empresa->where($array)->first();
		$data['iva'] = $this->config->select('id, iva')->get()->getResult();*/
        $data['dataConfig'] = $this->epsconfig_lib->getData();
		return view('login/index', $data);
	}
	public function auth()
	{
		$session = session();
		$email = $this->request->getVar('email');
		$password = $this->request->getVar('password');
		$data = $this->clientes->where('email', $email)->first();
		if ($data) {
			$pass = $data['password'];
			//$verify_pass = password_verify($password, $pass);
			if ($pass === $password) {
				$ses_data = [
					'user_id'       => $data['id'],
					'user_name'     => $data['contacto'],
					'user_email'    => $data['email'],
					'user_role'     => $data['role'],
					'user_cargo'     => $data['cargo'],
					'user_activo'   => $data['activo'],
					'logged_in'     => TRUE
				];
				$session->set($ses_data);
				return redirect()->to('dashboard/');
			} else {
				//$session->setFlashdata('msg', ['type' => 'warning', 'body'=>'Password incorrecto']);
				return redirect()->route('login')->with('msg', ['type' => 'warning', 'body' => 'Password incorrecto']);
			}
		} else {
			return redirect()->route('login')->with('msg', ['type' => 'warning', 'body' => 'Email no se encuentra en la base de datos']);
		}
	}
	public function logout()
	{
		$session = session();
		$session->destroy();
		return redirect()->to('login');
	}
}