<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;

use App\Models\OrdenesModel;

class OrdenesController extends BaseController
{
    public function __construct()
    {
        helper(["url", "form", "session", "epscolor"]);
        $this->epsconfig_lib = new \App\Libraries\EpsConfig_Lib();

        $this->ordenes = new OrdenesModel();  
    }

    public function listaordenes()
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('ordenes');
        $builder->select('equipos.*,clientes.*,ordenes.*');
        $builder->join('clientes', 'ordenes.id_cliente = clientes.id');
        $builder->join('equipos', 'ordenes.id_equipo = equipos.id');
        $builder->orderBy('ordenes.id', 'DESC');

        $query = $builder->get()->getResult();
        $data['ordenes'] = $query;

        $respuesta = $query;
        echo json_encode($respuesta);
    }

    public function listaordenes_id()
    {
        $tecnico = session()->get('user_name');
        //$array = ['tecnico' => $tecnico];
        //$respuesta = $this->ordenes->where($array)->orderBy('id', 'desc')->findAll();
        $db      = \Config\Database::connect();
        $builder = $db->table('ordenes');
        $builder->select('equipos.*,clientes.*,ordenes.*');
        $builder->where('ordenes.tecnico', $tecnico);
        $builder->where('ordenes.estado !=', 'Finalizada');
        $builder->join('clientes', 'ordenes.id_cliente = clientes.id');
        $builder->join('equipos', 'ordenes.id_equipo = equipos.id');
        $builder->orderBy('ordenes.id', 'DESC');

        $query = $builder->get()->getResult();
        $respuesta = $query;
        echo json_encode($respuesta);
    }

    public function ordenes_list(): string
    {
        $data['dataConfig'] = $this->epsconfig_lib->getData();

        if (session()->get('user_cargo') != 'Tecnico') {
            $data['tablaurl'] = 'ordenes/listaordenes';
        } else {
            $data['tablaurl'] = 'ordenes/listaordenes_id';
        }
        return view ('ordenes/ordenes_list', $data);
        
    }

    public function add_ordenes()
    {
        if ($this->request->getPost()) {

            $id_cliente = formato_uppercase($this->request->getVar('id_cliente'));
            $id_equipo = formato_uppercase($this->request->getVar('id_equipo'));

            $falla_reportada = ucwords($this->request->getVar('falla_reportada'));
            $informe  = ucwords($this->request->getVar('informe'));
            $tipo_servicio  = trim($this->request->getVar('tipo_servicio'));
            $fecha_visita  = trim($this->request->getVar('fecha_visita'));
            $tecnico  = formato_capitalize($this->request->getVar('tecnico'));


            $session = session();
            $user_name = $session->get('user_name');

            $estado = "Ingresada";

            //$array = ['serial' => $serial];
            $array = ['id_equipo' => $id_equipo, 'completado' => 1];
            $data = $this->ordenes->where($array)->first();

            if ($data) {
                $mensaje = array('mensaje' => 'Equipo posee una orden abierta sin completar');
                $success = array('success' => 'add_error');
                $data = array('data' => $data);

                $response = array_merge($data, $mensaje, $success);
            } else {

                $data1 = [
                    "id_cliente" => $id_cliente,
                    "id_equipo" => $id_equipo,
                    "estado" => $estado,
                    "falla_reportada" => $falla_reportada,
                    "informe" => $informe,
                    "tipo_servicio" => $tipo_servicio,
                    "fecha_visita" => $fecha_visita,
                    "tecnico" => $tecnico,
                    "usuario" => $user_name,
                ];
                $id = $this->ordenes->insert($data1);
                $data = $this->ordenes->find($id);

                $mensaje = array('mensaje' => 'Equipo almacendado en la base de datos');
                $success = array('success' => 'add_ok');
                $data = array('data' => $data);

                $response = array_merge($data, $mensaje, $success);
            }
        }
        echo json_encode($response);
    }

    public function edit_ordenes()
    {
        if ($this->request->getPost()) {
            $id = formato_uppercase($this->request->getVar('id_orden'));
            $id_cliente = formato_uppercase($this->request->getVar('id_cliente'));
            $id_equipo = formato_uppercase($this->request->getVar('id_equipo'));

            $falla_reportada = ucwords($this->request->getVar('falla_reportada'));
            $informe  = ucwords($this->request->getVar('informe'));
            $tipo_servicio  = trim($this->request->getVar('tipo_servicio'));
            $fecha_visita  = trim($this->request->getVar('fecha_visita'));
            $tecnico  = formato_capitalize($this->request->getVar('tecnico'));
            $estado  = formato_capitalize($this->request->getVar('estado'));
            $completado = $this->request->getVar('check_completado');
            if(isset($completado)) {$completado = '1'; } else {$completado = '0';}


            $session = session();
            $user_name = $session->get('user_name');

            //$array = ['serial' => $serial];
            $array = ['id' => $id, 'completado' => 1];
            $data = $this->ordenes->where($array)->first();

            if ($data) {
                $mensaje = array('mensaje' => 'Orden cerrada completada... Abrir otra orden');
                $success = array('success' => 'add_error');
                $data = array('data' => $data);

                $response = array_merge($data, $mensaje, $success);
            } else {

                $data1 = [
                    "id_cliente" => $id_cliente,
                    "id_equipo" => $id_equipo,
                    "estado" => $estado,
                    "falla_reportada" => $falla_reportada,
                    "informe" => $informe,
                    "tipo_servicio" => $tipo_servicio,
                    "fecha_visita" => $fecha_visita,
                    "tecnico" => $tecnico,
                    "completado" => $completado,
                    "usuario" => $user_name,
                ];
                $id = $this->ordenes->update($id, $data1);
                $data = $this->ordenes->find($id);

                $mensaje = array('mensaje' => 'Datos actualizados en la base de datos');
                $success = array('success' => 'add_ok');
                $data = array('data' => $data);

                $response = array_merge($data, $mensaje, $success);
            }
        }
        echo json_encode($response);
    }
}
