<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\HTTP\ResponseInterface;

use App\Models\ProductosModel;

class ProductosController extends BaseController
{
    public function __construct()
    {
        helper(["url", "form", "session", "epscolor"]);
        $this->epsconfig_lib = new \App\Libraries\EpsConfig_Lib();

        $this->productos = new ProductosModel();  
    }

    public function index()
    {
        $data['dataConfig'] = $this->epsconfig_lib->getData();
        return view ('productos/productos_list', $data);
    }

    public function search_productos()
    {

        $data['dataConfig'] = $this->epsconfig_lib->getData();

        $match = $this->request->getVar('search_productos');

        $builder = $this->productos->like('contacto', $match)->orLike('telefono1', $match)->orLike('razonsocial', $match);
        $data['productos'] =  $builder->get()->getResult();

        /* $db = \Config\Database::connect();
        $builder = $db->table('productos');    
        $builder->like('contacto', $match);   
        $builder->orLike('telefono1', $match);   
        $builder->orLike('rif', $match);   
        $builder->orLike('razonsocial', $match);
        $data['productos'] = $builder->get()->getResult();*/

        return view('productos/productos_search', $data);
    }

    public function productos_show($id = null)
    {
        $data['dataConfig'] = $this->epsconfig_lib->getData();
        $data['cliente'] = $this->productos->find($id);

        return view('productos/productos_show', $data);
    }

    public function listaproductos() {
        $respuesta = $this->productos->orderBy('id', 'desc')->get()->getResultArray();
        echo json_encode($respuesta);
    }

    public function productos_list(): string
    {
        $data['dataConfig'] = $this->epsconfig_lib->getData();

        $data['tablaurl'] = 'productos/listaproductos';
        return view ('productos/productos_list', $data);
    }

    public function productos_add(): string
    {
        $data['dataConfig'] = $this->epsconfig_lib->getData();
        return view ('productos/productos_add', $data);
    }

    public function add_productos()
    {
        if ($this->request->getPost()) {
            $codigo = formato_uppercase($this->request->getVar('codigo'));
            $descripcion  = formato_capitalize($this->request->getVar('descripcion'));

            $array = ['descripcion' => $descripcion];
            $data = $this->productos->where($array)->first();

            if ($data) {
                $mensaje = array('mensaje' => 'Descripcion existe en la base de Datos');
                $success = array('success' => 'add_error');
                $data = array ('data' => $data);
                $response = array_merge($data, $mensaje, $success);
            } else {

                $stock  = trim($this->request->getVar('stock'));
                $costo_d  = trim($this->request->getVar('costo_d'));
                $precio_d  = trim($this->request->getVar('precio_d'));
                $precio_bs  = trim($this->request->getVar('precio_bs'));
                $tasa  = trim($this->request->getVar('tasa_inv'));
 
                $categoria  = formato_capitalize($this->request->getVar('categoria'));
                $compatible_con  = formato_capitalize($this->request->getVar('compatible_con'));
                $condicion  = formato_capitalize($this->request->getVar('condicion'));
                $foto = $this->request->getFile('foto');
                $tienda = $this->request->getVar('check_tienda');
                    if(isset($tienda)) {$tienda = '1'; } else {$tienda = '0';}  


                $result = $this->productos->select('max(id) as maxId')->first();
                $max_id = $result['maxId'];
                $max_id++;
                if ( $foto->isValid()) {
                        $imagen = $this->request->getFile('foto');
                        $imagen_ext = $imagen->guessExtension();
                        $imagen_name = $max_id .'_'. $codigo .'_'. $descripcion .'.'. $imagen_ext;
                        $imagen->move(ROOTPATH . 'public/assets/epscolor/img/productos', $imagen_name, true);
                } else {$imagen_name = '';}
                    

                $data1 = [
                    "codigo" => $codigo,
                    "descripcion" => $descripcion,
                    "stock" => $stock,                  
                    "costo_d" => $costo_d,
                    "precio_d" => $precio_d,
                    "precio_bs" => $precio_bs,                  
                    "tasa" => $tasa,
                    "categoria" => $categoria,
                    "condicion" => $condicion,
                    "compatible_con" => $compatible_con,
                    "foto" => $imagen_name,
                    "tienda" => $tienda,
                ];

                $id = $this->productos->insert($data1);
                $data = $this->productos->find($id);

                $mensaje = array('mensaje' => 'Datos almacendado en la base de datos');
                $success = array('success' => 'add_ok');
                $data = array ('data' => $data);

                $response = array_merge($data, $mensaje, $success);
            }
        }
        echo json_encode($response);
    }

    public function edit_productos()
    {
        if ($this->request->getPost()) {

            $id = trim($this->request->getVar('id_producto'));

            $array = ['id' => $id];
            $data = $this->productos->where($array)->first();

            if ($data) {
                $codigo = formato_uppercase($this->request->getVar('codigo'));
                $descripcion  = formato_capitalize($this->request->getVar('descripcion'));
                $stock  = trim($this->request->getVar('stock'));

                $costo_d  = trim($this->request->getVar('costo_d_edit'));
                $precio_d  = trim($this->request->getVar('precio_d_edit'));
                $precio_bs  = trim($this->request->getVar('precio_bs_edit'));
                $tasa  = trim($this->request->getVar('tasa_productos_edit'));
                $categoria  = formato_capitalize($this->request->getVar('categoria_edit'));
                $condicion  = formato_capitalize($this->request->getVar('condicion_edit'));
                $compatible_con  = formato_capitalize($this->request->getVar('compatible_con'));
                $foto = $this->request->getFile('foto_edit');
                $tienda = $this->request->getVar('check_tienda_edit');
                    if(isset($tienda)) {$tienda = '1'; } else {$tienda = '0';}

                if ( $foto->isValid()) {
                        $imagen = $foto;
                        $imagen_ext = $imagen->guessExtension();
                        $imagen_name = $id .'_'. $codigo .'_'. $descripcion .'.'. $imagen_ext;
                        $imagen->move(ROOTPATH . 'public/assets/epscolor/img/productos', $imagen_name, true);
                } else {$imagen_name = $data['foto'];}

                $data1 = [
                    "codigo" => $codigo,
                    "descripcion" => $descripcion,
                    "stock" => $stock,                  
                    "costo_d" => $costo_d,
                    "precio_d" => $precio_d,
                    "precio_bs" => $precio_bs,                  
                    "tasa" => $tasa,
                    "categoria" => $categoria,
                    "condicion" => $condicion,
                    "compatible_con" => $compatible_con,
                    "foto" => $imagen_name,
                    "tienda" => $tienda,
                ];
                $this->productos->update($id, $data1);
                $data = $this->productos->find($id);

                $mensaje = array('mensaje' => 'Datos actualizado en la base de datos');
                $success = array('success' => 'add_ok');
                $data = array('data' => $data);
                $response = array_merge($data, $mensaje, $success);
            } else {
                $data = [];
                $mensaje = array('mensaje' => 'ID de cliente requerido');
                $success = array('success' => 'add_error');
                $data = array('data' => $data);
                $response = array_merge($data, $mensaje, $success);

            }

        }
        echo json_encode($response);
    }

}
