<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class ConfigsMigration extends Migration
{
    public function up()
    {
		$this->forge->addField([
		    "id" => [
		        "type" => "INT",
		        "auto_increment" => true,
		        "unsigned" => true,
		        "constraint" => 2
		    ],
		    "id_config" => [
		        "type" => "INT",
		        "unique"  => true,
		        "constraint" => 2
		    ],
		    "iva" => [
		        "type" => "DECIMAL",
		        "constraint" => "10,2",
		        "null" => false
		    ],
		    "tasa" => [
		        "type" => "DECIMAL",
		        "constraint" => "10,2",
		        "null" => false
		    ],

		    'created_at datetime default current_timestamp',
		    'updated_at datetime default current_timestamp on update current_timestamp', 
		]);

		$this->forge->addPrimaryKey("id");
		$this->forge->createTable("configs");
    }

    public function down()
    {
		$this->forge->dropTable("configs");
    }
}
