<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class ClientesMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id" => [
                "type" => "INT",
                "auto_increment" => true,
                "unsigned" => true,
                "constraint" => 5
            ],
            "telefono1" => [
                "type" => "VARCHAR",
                "constraint" => 30,
                "unique"  => true,
                "null" => false
            ],
            "contacto" => [
                "type" => "VARCHAR",
                "constraint" => 200,
                "null" => false
            ],
            "password" => [
                "type" => "VARCHAR",
                "constraint" => 10,
                "null" => false
            ],
            "rif" => [
                "type" => "VARCHAR",
                "constraint" => 30,
                "null" => true
            ],
            "razonsocial" => [
                "type" => "VARCHAR",
                "constraint" => 200,
                "null" => true
            ],
            "telefono2" => [
                "type" => "VARCHAR",
                "constraint" => 30,
                "null" => true
            ],
            "email" => [
                "type" => "VARCHAR",
                "constraint" => 200,
                "null" => true
            ],            
            "direccion" => [
                "type" => "TEXT",
                "null" => true
            ],
            "avatar" => [
                "type" => "VARCHAR",
                "constraint" => 200,
                "null" => true
            ],
            "role" => [
                "type" => "VARCHAR",
                "constraint" => 100,
                "null" => true
            ],
            "cargo" => [
                "type" => "VARCHAR",
                "constraint" => 100,
                "null" => true
            ],
            "activo" => [
                "type" => "TINYINT",
                "constraint" => 2,
                "default" => 0
            ],

            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp', 
        ]);

        $this->forge->addPrimaryKey("id");
        $this->forge->createTable("clientes");
    }

    public function down()
    {
        $this->forge->dropTable("clientes");
    }
}
