<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class ProductosMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id" => [
                "type" => "INT",
                "auto_increment" => true,
                "unsigned" => true,
                "constraint" => 5
            ],
            "codigo" => [
                "type" => "VARCHAR",
                "constraint" => 100,
                "null" => false
            ],
            "descripcion" => [
                "type" => "TEXT",
                "null" => true
            ],
            "costo_d" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "precio_d" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "precio_bs" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "tasa" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "stock" => [
                "type" => "INT",
                "constraint" => 5,
                "null" => false
            ],
            "foto" => [
                "type" => "VARCHAR",
                "constraint" => 150,
                "null" => true
            ],
            "condicion" => [
                "type" => "VARCHAR",
                "constraint" => 150,
                "null" => true
            ],
            "categoria" => [
                "type" => "VARCHAR",
                "constraint" => 150,
                "null" => true
            ],
            "compatible_con" => [
                "type" => "VARCHAR",
                "constraint" => 500,
                "null" => true
            ],
            "tienda" => [
                "type" => "TINYINT",
                "constraint" => 2,
                "default" => 0
            ],


            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp', 
        ]);

        $this->forge->addPrimaryKey("id");
        $this->forge->createTable("productos");
    }

    public function down()
    {
        $this->forge->dropTable("productos");
    }
}
