<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class EquiposMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id" => [
                "type" => "INT",
                "auto_increment" => true,
                "unsigned" => true,
                "constraint" => 2
            ],
            "id_cliente" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
           ],
            "modelo" => [
                "type" => "VARCHAR",
                "constraint" => 80,
                "null" => true
            ],
            "linea" => [
                "type" => "VARCHAR",
                "constraint" => 80,
                "null" => true
            ],
            "serial" => [
                "type" => "VARCHAR",
                "constraint" => 80,
                "null"  => true,                
            ],

            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp', 
        ]);

        $this->forge->addPrimaryKey("id");
        $this->forge->addForeignKey('id_cliente', 'clientes', 'id', );
       
        $this->forge->createTable("equipos");
    }

    public function down()
    {
        $this->forge->dropTable("equipos");
    }
}
