<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class OrdenesMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id" => [
                "type" => "INT",
                "auto_increment" => true,
                "unsigned" => true,
                "constraint" => 2
            ],
            "id_cliente" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
           ],
           "id_equipo" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
           ],
            "estado" => [
                "type" => "VARCHAR",
                "null" => true,
                "constraint" => 80
            ],
            "falla_reportada" => [
                "type" => "VARCHAR",
                "null" => true,
                "constraint" => 560
            ],
            "informe" => [
                "type" => "TEXT",
                "null" => true
            ],
            "tipo_servicio" => [
                "type" => "VARCHAR",
                "null"  => true,
                "constraint" => 80
            ],
            "fecha_visita" => [
                "type" => "datetime",
                "null" => true
            ],
            "tecnico" => [
                "type" => "VARCHAR",
                "null" => true,
                "constraint" => 80
            ],
            "usuario" => [
                "type" => "VARCHAR",
                "null" => true,
                "constraint" => 80
            ],
            "completado" => [
                "type" => "TINYINT",
                "constraint" => 2,
                "default" => 0
            ],

            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp', 
        ]);

        $this->forge->addPrimaryKey("id");
        $this->forge->addForeignKey('id_cliente', 'clientes', 'id', );
        $this->forge->addForeignKey('id_equipo', 'equipos', 'id', );
       
        $this->forge->createTable("ordenes");
    }

    public function down()
    {
        $this->forge->dropTable("ordenes");
    }
}
