<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CotizacionesarticulosMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id" => [
                "type" => "INT",
                "auto_increment" => true,
                "unsigned" => true,
                "constraint" => 5
            ],
            "id_cotizacion" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
           ],
            "id_cliente" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
           ],
           "id_orden" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
               "null" => true,
           ],
           "id_producto" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
           ],
           "codigo" => [
                "type" => "VARCHAR",
                "constraint" => 100,
                "null" => false
            ],
            "descripcion" => [
                "type" => "TEXT",
                "null" => true
            ],
            "costo_d" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "precio_d" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "subtotal_d" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "precio_bs" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "stock" => [
                "type" => "INT",
                "constraint" => 5,
                "null" => false
            ],
            "cantidad" => [
                "type" => "INT",
                "constraint" => 5,
                "null" => false
            ],
            "tasa" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "condicion" => [
                "type" => "VARCHAR",
                "null" => true,
                "constraint" => 80
            ],
            "categoria" => [
                "type" => "VARCHAR",
                "null" => true,
                "constraint" => 80
            ],

            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp', 
        ]);

        $this->forge->addPrimaryKey("id");
        $this->forge->addForeignKey('id_cliente', 'clientes', 'id',);
        $this->forge->addForeignKey('id_orden', 'ordenes', 'id',);
        $this->forge->addForeignKey('id_cotizacion', 'cotizaciones', 'id',);
        $this->forge->addForeignKey('id_producto', 'productos', 'id',);
       
        $this->forge->createTable("cotizacionesarticulos");
    }

    public function down()
    {
        $this->forge->dropTable("cotizacionesarticulos");
    }
}
