<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class VentasMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id" => [
                "type" => "INT",
                "auto_increment" => true,
                "unsigned" => true,
                "constraint" => 5
            ],
            "id_cliente" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
           ],
           "id_orden" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
               "null" => true,
           ],
           "id_cotizacion" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
               "null" => true,
           ],
            "total_d" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "subtotal_d" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "total_bs" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "subtotal_bs" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "tasa" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "iva" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "estado" => [
                "type" => "VARCHAR",
                "null" => true,
                "constraint" => 80
            ],
            "categoria" => [
                "type" => "VARCHAR",
                "null" => true,
                "constraint" => 80
            ],
            "notas" => [
                "type" => "TEXT",
                "null" => true
            ],
            "vendedor" => [
                "type" => "VARCHAR",
                "null"  => true,
                "constraint" => 80
            ],
            "usuario" => [
                "type" => "VARCHAR",
                "null" => true,
                "constraint" => 80
            ],
            "completado" => [
                "type" => "TINYINT",
                "constraint" => 2,
                "default" => 0
            ],

            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp', 
        ]);

        $this->forge->addPrimaryKey("id");
        $this->forge->addForeignKey('id_cliente', 'clientes', 'id', );
        $this->forge->addForeignKey('id_orden', 'ordenes', 'id', );
        $this->forge->addForeignKey('id_cotizacion', 'cotizaciones', 'id', );
       
        $this->forge->createTable("ventas");
    }

    public function down()
    {
        $this->forge->dropTable("ventas");
    }
}
