<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CajaMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id" => [
                "type" => "INT",
                "auto_increment" => true,
                "unsigned" => true,
                "constraint" => 5
            ],
            "id_cliente" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
           ],
           "id_orden" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
               'null' => true,
           ],
           "id_nde" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
               'null' => true,
           ],
           "id_compra" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
               'null' => true,
           ],
           "id_venta" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
               'null' => true,
           ],
           "id_nomina" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
               'null' => true,
           ],
           "id_gasto" => [
               'type' => 'INT',
               'constraint' => 5,
               'unsigned' => true,
               'null' => true,
           ],
           "fecha_emision" => [
                "type" => "datetime",
                "null" => true
            ],
            "concepto" => [
                "type" => "TEXT",
                "null" => true
            ],
            "monto_d" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "monto_bs" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => true
            ],
            "tasa" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => true
            ],
            "total_d" => [
                "type" => "DECIMAL",
                "constraint" => "10,2",
                "null" => false
            ],
            "asiento" => [
                "type" => "VARCHAR",
                "null" => true,
                "constraint" => 80
            ],
            "categoria" => [
                "type" => "VARCHAR",
                "null" => true,
                "constraint" => 80
            ],
            "banco" => [
                "type" => "VARCHAR",
                "null" => true,
                "constraint" => 80
            ],
            "forma_pago" => [
                "type" => "VARCHAR",
                "null" => true,
                "constraint" => 80
            ],
            "ref" => [
                "type" => "VARCHAR",
                "null" => true,
                "constraint" => 80
            ],
            "pago_total" => [
                "type" => "TINYINT",
                "constraint" => 2,
                "default" => 0
            ],
            "usuario" => [
                "type" => "VARCHAR",
                "null" => true,
                "constraint" => 80
            ],

            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp', 
        ]);

        $this->forge->addPrimaryKey("id");
        $this->forge->addForeignKey('id_cliente', 'clientes', 'id',);
        $this->forge->addForeignKey('id_orden', 'ordenes', 'id',);
        $this->forge->addForeignKey('id_nde', 'nde', 'id',);        
        $this->forge->addForeignKey('id_compra', 'compras', 'id',);
        $this->forge->addForeignKey('id_venta', 'ventas', 'id',);
       
        $this->forge->createTable("caja");
    }

    public function down()
    {
        $this->forge->dropTable("caja");
    }
}
