<?php namespace App\Filters;
  
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;
  
class Auth implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        // if user not logged in
        if(!session()->get('logged_in')){
            // then redirct to login page
            return redirect()->to('login');
        }
        $model = model('ClientesModel');
        $user = $model->getClienteBy('id', session()->user_id);
        
        if ($user['activo'] === '0' ) {
           
			return redirect()->route('login')->with('msg', ['type' => 'warning', 'body' => 'Usuario inactivo. Contacte al administrador web']); 
        }
    }
  
    //--------------------------------------------------------------------
  
    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Do something here
    }
}