<?php

namespace App\Models;

use CodeIgniter\Model;

class ProductosModel extends Model
{
    protected $table            = 'productos';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'codigo',
        'descripcion',
        'costo_d',
        'precio_d',
        'precio_bs',
        'tasa',
        'stock',
        'foto',
        'condicion',
        'categoria',
        'compatible_con',
        'tienda',
    ];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    public function getProductoBy($key,$value)
    {
        // Create a shared instance of the model.
        $productosModel = model('ProductosModel');
        $data = $productosModel->where($key, $value)->first();
        return $data;
    }
    public function update_producto_suma ($data) {
        foreach($data as $item){
            $sql = " UPDATE productos SET stock = stock +'".$item['stock']."' WHERE id = '".$item['id_producto']."' ";
            $this->db->query($sql);
        }
    }
    public function update_producto_resta ($data) {
        foreach($data as $item){
            $sql = " UPDATE productos SET stock = stock -'".$item['stock']."' WHERE id = '".$item['id_producto']."' ";
            $this->db->query($sql);
        }
    }
}
