<?= $this->extend('layout/base_dashboard') ?>

<!-- CONTENIDO -->
<?= $this->section("content") ?>
	<div class="container">

		<div class="row ">
			
			<div class="card border-0 p-1">
				<div class="col-12">					
					
					<div class="d-flex justify-content-between align-items-center">
						<!-- DATOS CLIENTE BOTONES EDITAR WHATSAPP CREAR ORDEN -->
						<div class="me-auto">
							<a class="btn btn-sm text-start" title="Editar Cliente" id="btn_clientes_edit">
								<?php if ((isset($cliente['razonsocial'])) && (!empty($cliente['razonsocial']))) { ?> 
									<strong><span><?php echo $cliente['razonsocial'];?> </span></strong><br>
								<?php } ?> 
								<span><?= $cliente['contacto'] ?></span>
							</a> 
							<br>

							<small><a class="btn btn-sm btn-light" title="Llamar Cliente" href="tel:<?= $cliente['telefono1'] ?>"><?= $cliente['telefono1'] ?></a></small>
						</div>
						
						<div> 
							<a class="btn btn-sm btn-light me-2" title="Hacer Cotizacion" href="<?= base_url('cotizaciones/coti_add_id_cliente/'. $cliente['id'] ) ?>" ><i class="bi bi-clipboard-plus icon-20"></i>  </a> 
						</div>

						<div> 
							<a class="btn btn-sm btn-light me-2" title="Enviar WhatsApp" aria-label="Chat on WhatsApp" href="https://wa.me/<?= $cliente['telefono1'] ?>"> <i class="bi bi-whatsapp icon-20"></i></a>
						</div>

						<div>
							<div class="btn-group">
								<button class="btn btn-light btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false" title="Crear Orden">
									<i class="bi bi-life-preserver icon-20"></i>
								</button>
								<ul class="dropdown-menu dropdown-menu-dark">
								    <div class="alert alert-info p-1 mx-2" role="alert">
										Seleccione un equipo de la lista.<br> Si no aparece haga click en Registro equipo
									</div>
									<?php if (isset($equipos)) { foreach ($equipos as $item) { ?>
										
										<li class="d-flex justify-content-start mb-1">

											<a class="dropdown-item btn btn-light" title="Crear Orden" onclick="crearOrden(this)" data-id="<?= $item->id ?>" >

												<div class="d-flex justify-content-between">
													<div class=""><?= $item->modelo ?> <?= $item->serial ?></div>		
													<div class=""><?= $item->linea ?></div>									
												</div>

											</a>
											<button class="btn btn-sm btn-light me-2" title="Editar Equipo" onclick="equipoEdit(this)"  data-modelo="<?= $item->modelo ?>" data-linea="<?= $item->linea ?>" data-serial="<?= $item->serial ?>" data-id="<?= $item->id ?>"><i class="bi bi-pencil" style="font-size: 13px"></i>
											</button>

										</li>
									<?php }  } ?>

									<li><hr class="dropdown-divider"></li>
									<li>
										<a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#modal_equipos_add" title="Add equipo"><i class="bi bi-printer"></i> Registro equipos</a>
									</li>
								</ul>
							</div>
						</div>
					</div>

				</div>
			</div>
		</div>

		<!-- ORDENES CLIENTE -->
		<?php if ($ordenes) {
            //$total = count((array)$allordenes);
            $ingresadas = 0;
            $revision = 0;
            $cotizacion = 0;
            $finalizadas = 0;
            $entregadas = 0;
            $completadas = 0;
            $tecnicos = 0;
            foreach ($ordenes as $item) {
               if ($item->estado === 'Ingresada') {
                  $ingresadas++;
               } else if ($item->estado === 'Revision') {
                  $revision++;
               } else if ($item->estado === 'Cotizacion') {
                  $cotizacion++;
               } else if ($item->estado === 'Finalizadas') {
                  $finalizadas++;
               } else if ($item->estado === 'Entregadas') {
                  $entregadas++;
               } else if ($item->estado === 'Completadas') {
                  $completadas++;
               }
            } 
          ?>
			<div class="row mt-2">
				<div class="card col-lg-4 col-12 p-2">
					<div class="d-flex justify-content-between align-items-center">
						<div class=""><i class="bi bi-grid icon-20 me-2 align-middle"></i>Ordenes</div>
						<div class=""><?php echo count($ordenes); ?></div>
					</div>
					<div class="d-flex justify-content-start">
						<?php if ($ingresadas>0) { ?>
						<a href="" class="me-3">
							<span class="text-info" style="font-size: 12px;">
								<small>Ingresadas: <?= $ingresadas ?> </small></span>
						</a>
						<?php } if ($revision>0) { ?>
						<a href="" class="">
							<span class="text-warning" style="font-size: 12px;">
								<small>Revision: <?= $revision ?> </small></span>
						</a>
						<?php } if ($cotizacion>0) { ?>
						<a href="" class="me-3">
							<span class="text-warning" style="font-size: 12px;">
								<small>Cotizacion: <?= $cotizacion ?> </small></span>
						</a>
						<?php } if ($finalizadas>0) { ?>
						<a href="" class="">
							<span class="text-muted" style="font-size: 12px;">
								<small>Finalizadas: <?= $finalizadas ?> </small></span>
						</a>
						<?php } if ($entregadas>0) { ?>
						<a href="" class="">
							<span class="text-muted" style="font-size: 12px;">
								<small>Entregadas: <?= $entregadas ?> </small></span>
						</a>
						<?php } if ($completadas>0) { ?>
						<a href="" class="">
							<span class="text-muted" style="font-size: 12px;">
								<small>Completadas: <?= $completadas ?> </small></span>
						</a>
						<?php } ?>
					</div>
				</div>
			</div>
		<?php } ?>

		<?php if (isset($ordenes)) { foreach ($ordenes as $item) { ?>
			
			<div class="row" >

				<div class="card col-lg-12 col-12 p-2">
					<div class="d-flex justify-content-between" data-bs-toggle="collapse" data-bs-target="#collapseExample<?= $item->id ?>" aria-expanded="false" aria-controls="collapseExample">
						<div class="text-start">Orden <?= $item->id ?> <br>
							<span style="line-height: 0.85rem; font-size: 10px;"><?= formato_fecha2($item->fecha_visita) ?></span>
						</div>

						<div class="text-center"><?= $item->modelo ?> <br>
							<span> <small><?= $item->serial ?></small> </span>
						</div>	
						<div class="text-end">
							<span class="badge text-bg-info"><?= $item->estado ?></span> <br>
							<span> <small><?= $item->tipo_servicio ?></small> </span>
						</div>
					</div>


					<div class=" col-12 collapse " id="collapseExample<?= $item->id ?>" >
					
						<div>
							<div class="alert alert-info p-2 m-0" style="word-break: break-all; line-height: 0.95rem; font-size: 11px;"><?= $item->informe ?></div>
						</div>
						<div class="d-flex justify-content-between alert alert-light p-1 m-0" style="line-height: 0.85rem; font-size: 10px;">
							<div class=""   >Realizado: <?= formato_fecha($item->fecha_visita) ?> </div>
							<div><?= $item->tecnico ?></div>
						</div>
					

						<hr class="text-success">

						<!-- TAB MENU -->
						<div class="flex-container">
							<div class="nav nav-tabs" id="nav-tab" role="tablist">

								<a class="nav-link active" id="nav-one-tab" data-bs-toggle="tab" data-bs-target="#nav-one<?= $item->id ?>" type="button" role="tab" aria-controls="nav-one" aria-selected="true">Cotizacion</a>
								<a class="nav-link" id="nav-two-tab" data-bs-toggle="tab" data-bs-target="#nav-two<?= $item->id ?>" type="button" role="tab" aria-controls="nav-two" aria-selected="false">Nde</a>
								<a class="nav-link" id="nav-three-tab" data-bs-toggle="tab" data-bs-target="#nav-three<?= $item->id ?>" role="tab" type="button" aria-controls="nav-three" aria-selected="false">Factura</a>
								<a class="nav-link" id="nav-four-tab" data-bs-toggle="tab" data-bs-target="#nav-four<?= $item->id ?>" role="tab" type="button" aria-controls="nav-four" aria-selected="false">Informe</a>
							</div>
						</div>
						<!-- TAB CONTENT -->
						<div id="content-wrap">
							<div class="tab-content" id="nav-tabContent">
								
								<!-- COTIZACIONES -->
								<div class="tab-pane fade show active" id="nav-one<?= $item->id ?>" role="tabpanel" aria-labelledby="nav-one-tab" tabindex="0">
									
									<div class="card p-1 border-0">
										<div class="d-flex justify-content-between align-items-center">
											<div></div>
											<div>
												<a href="<?= base_url('cotizaciones/coti_add_id_orden/'. $item->id ) ?>" class="btn btn-sm btn-light p-1" title="Nueva Cotizacion"><i class="bi bi-clipboard-plus me-1"></i>Cotizacion</a>
											</div>

										</div>
									</div>

									<?php if (isset($cotizaciones)) { 
										foreach ($cotizaciones as $itemcot) {
											foreach ($itemcot as $valuecot) {
												if ($valuecot->id_orden == $item->id) { ?>

												<div class="card bg-light p-2 mb-2">
													<div class="col-12">
														<div class="d-flex justify-content-between" data-bs-toggle="collapse" data-bs-target="#collapseCotizacionDetalles<?= $valuecot->id ?>">
															<div>
																<span>Cotizacion <?= $valuecot->id ?></span><span class="badge text-bg-info ms-2"><?= $valuecot->estado ?></span>
															</div>
															<div>Total $: <?= $valuecot->total_d ?></div>
														</div>
													</div>

													<div class="card bg-light border-0 p-2 collapse" id="collapseCotizacionDetalles<?= $valuecot->id ?>">

														<?php if (isset($cotizacionesarticulos)) { foreach ($cotizacionesarticulos as $itemcotar) { 
															foreach ($itemcotar as $valuecotar) { ?>

															<?php  if ($valuecotar->id_cotizacion == $valuecot->id) { ?>
															<div class="">
																<div class="d-flex justify-content-start">
																	<div><?= $valuecotar->descripcion ?></div>
																	<div class="ms-auto"><?= $valuecotar->precio_d ?></div>
																</div>
															</div>
														<?php } } } } ?>


														<div class="row border-top mt-2">
															<div class="col-1"></div>
															<div class="col-4"></div>											
															<div class="col-4">Subtotal</div>
															<div class="col-3 text-end"><?= number_format($valuecot->subtotal_d, 2,",",".") ?></div>
														</div>
														<div class="row">
															<div class="col-1"></div>
															<div class="col-4"></div>											
															<div class="col-4">Iva 16%</div>
															<div class="col-3 text-end"><?= number_format($valuecot->iva, 2,",",".") ?></div>
														</div>
														<div class="row">
															<div class="col-1"></div>
															<div class="col-4"></div>											
															<div class="col-4 bg-info text-dark py-2">Total</div>
															<div class="col-3 bg-info text-dark py-2 text-end"><?= number_format($valuecot->total_d, 2,",",".") ?></div>
														</div>

														<div class="d-flex justify-content-start align-items-center mt-3">
															<div>
	                            								<a href="<?= base_url('nde/coti_nde_add/'. $valuecot->id ) ?>" class="btn btn-sm me-1" title="Enviar a Nota de Entrega"><i class="bi bi-clipboard-check"></i></a>
	                            							</div>
	                            							<div>
	                            								<a href="<?= base_url('compras/compras_ventas_add/'. $valuecot->id ) ?>" class="btn btn-sm me-1" title="Enviar a Facturacion"><i class="bi bi-credit-card"></i></a>
	                            							</div>
	                            							<div>
	                            								<a href="<?= base_url('compras/cotizaciones_compras_add/'. $valuecot->id ) ?>" class="btn btn-sm me-1" title="Enviar a Compras"><i class="bi bi-cart"></i></a>
	                            							</div>
															<div class="ms-auto">
																<a href="<?= base_url('cotizaciones/cotizaciones_add/'. $valuecot->id ) ?>" class="btn btn-sm me-1" title="Editar  Cotizacion"><i class="bi bi-pencil"></i></a>
															</div>
															
	                    									<div class="ms-1">
	                    										<a href="<?= base_url('imprimir/imprimir_cotizacion/'. $valuecot->id ) ?>" class="btn btn-sm me-1" title="Imprimir Cotizacion"><i class="bi bi-printer"></i></a>
	                    									</div>
	                    									<div class="ms-1">
	                    										<a href="https://wa.me/<?= $item->telefono1 ?>?text=*Orden%20<?= $item->id ?>*%20Cotizacion%20<?= $valuecot->id ?>%20Total:%20 <?= number_format($valuecot->total_d, 2,",",".") ?>$ %20Detalles:%20<?= base_url('imprimir/imprimir_cotizacion/'. $valuecot->id ) ?>" class="btn btn-sm btn-success" title="Enviar al Whatsapp"><i class="bi bi-whatsapp"></i></a>
	                    									</div>
														</div>
													</div>
													
													
												</div>

											<?php	}
											}									
										}
									} ?>
								</div>

								<!-- NOTAS DE ENTREGAS -->
								<div class="tab-pane fade" id="nav-two<?= $item->id ?>" role="tabpanel" aria-labelledby="nav-two-tab" tabindex="0">
									
									<?php if (isset($nde)) { 
										foreach ($nde as $itemcot) {
											foreach ($itemcot as $valuecot) {
												if ($valuecot->id_orden == $item->id) { ?>

												<div class="card p-2 mb-2">
													<div class="col-12 bg-light p-1">
														<div class="d-flex justify-content-between" data-bs-toggle="collapse" data-bs-target="#collapseNdeDetalles<?= $valuecot->id ?>">
															<div>
																<span>Nota de Entrega <?= $valuecot->id ?></span><span class="badge text-bg-info ms-2"><?= $valuecot->estado ?></span>
															</div>
															<div>Total $: <?= $valuecot->total_d ?></div>
														</div>
													</div>

													<div class="card bg-light border-0 p-2 collapse" id="collapseNdeDetalles<?= $valuecot->id ?>">

														<?php if (isset($ndearticulos)) { foreach ($ndearticulos as $itemcotar) { 
															foreach ($itemcotar as $valuecotar) { ?>

															<?php  if ($valuecotar->id_nde == $valuecot->id) { ?>
															<div class="">
																<div class="d-flex justify-content-start">
																	<div><?= $valuecotar->descripcion ?></div>
																	<div class="ms-auto"><?= $valuecotar->precio_d ?></div>
																</div>
															</div>
														<?php } } } } ?>


														<div class="row border-top mt-2">
															<div class="col-1"></div>
															<div class="col-4"></div>											
															<div class="col-4">Subtotal</div>
															<div class="col-3 text-end"><?= number_format($valuecot->subtotal_d, 2,",",".") ?></div>
														</div>
														<div class="row">
															<div class="col-1"></div>
															<div class="col-4"></div>											
															<div class="col-4">Iva 16%</div>
															<div class="col-3 text-end"><?= number_format($valuecot->iva, 2,",",".") ?></div>
														</div>
														<div class="row">
															<div class="col-1"></div>
															<div class="col-4"></div>											
															<div class="col-4 bg-dark text-light">Total</div>
															<div class="col-3 bg-dark text-light text-end"><?= number_format($valuecot->total_d, 2,",",".") ?></div>
														</div>

														<div class="d-flex justify-content-start align-items-center mt-3">
															<div>
																<a href="<?= base_url('cotizaciones/cotizaciones_add/'. $item->id ) ?>" class="btn btn-sm" title="Enviar a Facturacion"><i class="bi bi-credit-card me-1"></i></a>
															</div>
															<div>
																<a href="<?= base_url('caja/caja_add_id_nde/'. $valuecot->id ) ?>" class="btn btn-sm" title="Enviar a Caja"><i class="bi bi-cash-coin me-1"></i></a>
															</div>
															<div class="ms-auto">
																<a href="<?= base_url('cotizaciones/cotizaciones_add/'. $item->id ) ?>" class="btn btn-sm btn-warning p-1" title="Editar  Cotizacion"><i class="bi bi-pencil"></i></a>
															</div>
															<div class="ms-1">
	                    										<a href="<?= base_url('imprimir/imprimir_nde/'. $valuecot->id ) ?>" class="btn btn-sm btn-warning p-1" title="Imprimir Nota de Entrega"><i class="bi bi-printer"></i></a>
	                    									</div>
	                    									<div class="ms-1">
	                    										<a href="https://wa.me/<?= $item->telefono1 ?>?text=*Orden%20<?= $item->id ?>*%20Nota%20de%20Entrega%20<?= $valuecot->id ?>%20Total:%20 <?= number_format($valuecot->total_d, 2,",",".") ?>$ %20Detalles:%20<?= base_url('imprimir/imprimir_nde/'. $valuecot->id ) ?>" class="btn btn-sm btn-success p-1" title="Enviar al Whatsapp"><i class="bi bi-whatsapp"></i></a>
	                    									</div>
														</div>
													</div>
													
													
												</div>

											<?php	}
											}									
										}
									} ?>

								</div>

								<!-- FACTURAS -->
								<div class="tab-pane fade" id="nav-three<?= $item->id ?>" role="tabpanel" aria-labelledby="nav-three-tab" tabindex="0">

									<?php if (isset($ventas)) { 
										foreach ($ventas as $itemcot) {
											foreach ($itemcot as $valuecot) {
												if ($valuecot->id_orden == $item->id) { ?>

												<div class="card p-2 mb-2">
													<div class="col-12 bg-light p-1">
														<div class="d-flex justify-content-between" data-bs-toggle="collapse" data-bs-target="#collapseVentasDetalles<?= $valuecot->id ?>">
															<div>
																<span>Factura <?= $valuecot->id ?></span><span class="badge text-bg-info ms-2"><?= $valuecot->estado ?></span>
															</div>
															<div>Total $: <?= $valuecot->total_d ?></div>
														</div>
													</div>

													<div class="card bg-light border-0 p-2 collapse" id="collapseVentasDetalles<?= $valuecot->id ?>">

														<?php if (isset($ventasarticulos)) { foreach ($ventasarticulos as $itemcotar) { 
															foreach ($itemcotar as $valuecotar) { ?>

															<?php  if ($valuecotar->id_venta == $valuecot->id) { ?>
															<div class="">
																<div class="d-flex justify-content-start">
																	<div><?= $valuecotar->descripcion ?></div>
																	<div class="ms-auto"><?= $valuecotar->precio_d ?></div>
																</div>
															</div>
														<?php } } } } ?>


														<div class="row border-top mt-2">
															<div class="col-1"></div>
															<div class="col-4"></div>											
															<div class="col-4">Subtotal</div>
															<div class="col-3 text-end"><?= number_format($valuecot->subtotal_d, 2,",",".") ?></div>
														</div>
														<div class="row">
															<div class="col-1"></div>
															<div class="col-4"></div>											
															<div class="col-4">Iva 16%</div>
															<div class="col-3 text-end"><?= number_format($valuecot->iva, 2,",",".") ?></div>
														</div>
														<div class="row">
															<div class="col-1"></div>
															<div class="col-4"></div>											
															<div class="col-4 bg-dark text-light">Total</div>
															<div class="col-3 bg-dark text-light text-end"><?= number_format($valuecot->total_d, 2,",",".") ?></div>
														</div>

														<div class="d-flex justify-content-start align-items-center mt-3">
															
															<div class="ms-auto">
																<a href="<?= base_url('cotizaciones/cotizaciones_add/'. $item->id ) ?>" class="btn btn-sm btn-warning p-1" title="Editar  Cotizacion"><i class="bi bi-pencil"></i></a>
															</div>
															<div class="ms-1">
																<a href="<?= base_url('cotizaciones/cotizaciones_add/'. $item->id ) ?>" class="btn btn-sm btn-warning p-1" title="Imprimir Cotizacion"><i class="bi bi-printer"></i></a>
															</div>
														</div>
													</div>
													
													
												</div>

											<?php	}
											}									
										}
									} ?>

								</div>

								<!-- INFORME TECNICO -->
								<div class="tab-pane fade" id="nav-four<?= $item->id ?>" role="tabpanel" aria-labelledby="nav-four-tab" tabindex="0">
									<div class="row">
										<div class="col-12">
											<div class="card p-2"><?= $item->informe ?></div>
										</div>
									</div>
								</div>

							</div>
						</div>

					</div>

					<hr class="my-1">
					<div class="d-flex justify-content-between">
						<div class=""><small class="text-muted"  style="line-height: 0.85rem; font-size: 10px;" ><?= $item->falla_reportada ?></small> </div>
						<div>
							<a class="btn btn-sm btn-light" title="Editar Orden" onclick='editarOrden(<?php echo json_encode($item); ?>)' data-id="" ><i class="bi bi-pencil"></i></a>
						</div>
					</div>
				</div>
				
			</div>
		<?php } } ?>

		<!-- COTIZACIONES CLIENTE MERCANCIAS -->
		<?php if ((isset($cotizacionescliente)) && (!empty($cotizacionescliente))) { ?>
			<h6 class="mt-3">Cotizaciones</h6>
			<hr class="m-1">
			<div class="row mt-2">
				<?php foreach ($cotizacionescliente as $key => $value) { ?>
					<div class="card col-lg-4 col-12 p-2"  data-bs-toggle="collapse" data-bs-target="#collapseCotizacionDetalles<?= $key ?>" >
						<?php  if ($value->id_orden == null) { ?>

								<div class="d-flex justify-content-between align-items-center">
									<div class="">
										<span>Cotizacion <?= $value->id ?></span>
										<span class="badge text-bg-<?php if ($value->estado == 'Aceptada') {
											echo 'success';}elseif ($value->estado == 'Aceptada') { echo 'danger' ;}else{echo 'light';} ?> ms-2"><?= $value->estado ?></span> <br>
										<span><small><?= $value->categoria ?></small></span>
									</div>
									
									<div class="text-end">
										<span>Total $ <?= $value->total_d ?></span><br>
										<span><small>Iva 16% <?= $value->iva ?></small></span>
									</div>
								</div>
								
								<div class="card p-2 collapse" id="collapseCotizacionDetalles<?= $key ?>">
										
									<div class="row">
										<?php if (isset($cotiarticuloscliente)) { 
											foreach ($cotiarticuloscliente as $key => $valuear) { ?>

											<?php  if ($valuear->id_cotizacion == $value->id) { ?>
											<div class="">
												<div class="d-flex justify-content-start px-2">
													<div><small><?= $valuear->descripcion ?></small></div>
													<div class="ms-auto"><small><?= $valuear->precio_d ?></small></div>
												</div>
											</div>
										<?php } } } ?>
									</div>

									<hr class="m-2">

									<div class="row">
										<div class="d-flex justify-content-between">
											<div>
			    								<a href="<?= base_url('nde/coti_nde_add/'. $value->id ) ?>" class="btn me-1" title="Enviar a Nota de Entrega"><i class="bi bi-clipboard-check"></i></a>
			    							</div>		    							
			    							<div>
			    								<a href="<?= base_url('ventas/cotizaciones_ventas_add/'. $value->id ) ?>" class="btn me-1" title="Enviar a Facturacion"><i class="bi bi-credit-card"></i></a>
			    							</div>
			    							<div>
			    								<a href="<?= base_url('compras/cotizaciones_compras_add/'. $value->id ) ?>" class="btn me-1" title="Enviar a Compras"><i class="bi bi-cart"></i></a>
			    							</div>

			    							<div class="ms-auto">
												<button type="button" class="btn me-1" title="Cambiar Estado" onclick="editarCoti(this)" data-id="<?= $value->id ?>" data-id_cliente="<?= $value->id_cliente ?>" data-estado="<?= $value->estado ?>">  <i class="bi bi-arrow-down-up"></i></button> 
											</div>
											<div class="ms-1">
												<a href="<?= base_url('imprimir/imprimir_cotizacion/'. $value->id ) ?>" class="btn me-1" title="Imprimir Cotizacion"><i class="bi bi-printer"></i></a>
											</div>
											<div class="ms-1">
												<a href="https://wa.me/<?= $cliente['telefono1'] ?>?text=*Cotizacion%20<?= $value->id ?>%20Total:%20 <?= number_format($value->total_d, 2,",",".") ?>$ %20Detalles:%20<?= base_url('imprimir/imprimir_cotizacion/'. $value->id ) ?>" class="btn btn-success" title="Enviar al Whatsapp"><i class="bi bi-whatsapp"></i></a>
											</div>


										</div>
									</div>
								</div>
						<?php } ?>

					</div>
				<?php	} ?>
			</div>
		<?php } ?>


		<!-- NDE CLIENTE MERCANCIAS -->
		<?php if ((isset($ndecliente)) && (!empty($cotizacionescliente))) { ?>
			<h6 class="mt-3">Notas Entregas</h6>
			<hr class="m-1">
			<div class="row mt-2">
				<?php foreach ($ndecliente as $key => $value) { ?>
					<div class="card col-lg-4 col-12 p-2"  data-bs-toggle="collapse" data-bs-target="#collapseNdeDetalles<?= $key ?>" >
						<?php  if ($value->id_orden == null) { ?>

								<div class="d-flex justify-content-between align-items-center">
									<div class="">
										<span>Nota Entrega <?= $value->id ?></span>
										<span class="badge text-bg-<?php if ($value->estado == 'Cobrada') {
											echo 'success';}elseif ($value->estado == 'Anulada') { echo 'danger' ;}else{echo 'light';} ?> ms-2"><?= $value->estado ?></span> <br>
										<span><small><?= $value->categoria ?></small></span>
									</div>
									
									<div class="text-end">
										<span>Total $ <?= $value->total_d ?></span>
									</div>
								</div>
								
								<div class="card p-2 collapse" id="collapseNdeDetalles<?= $key ?>">
										
									<div class="row">
										<?php if (isset($ndearticuloscliente)) { 
											foreach ($ndearticuloscliente as $key => $valuear) { ?>

											<?php  if ($valuear->id_nde == $value->id) { ?>
											<div class="">
												<div class="d-flex justify-content-start px-2">
													<div><small><?= $valuear->descripcion ?></small></div>
													<div class="ms-auto"><small><?= $valuear->precio_d ?></small></div>
												</div>
											</div>
										<?php } } } ?>
									</div>

									<hr class="m-2">

									<div class="row">
										<div class="d-flex justify-content-between">	    							
			    							<div>
			    								<a href="<?= base_url('ventas/nde_ventas_add/'. $value->id ) ?>" class="btn me-1" title="Enviar a Facturacion"><i class="bi bi-credit-card"></i></a>
			    							</div>

			    							<div class="ms-auto">
												<button type="button" class="btn me-1" title="Cambiar Estado" onclick="editarNde(this)" data-id="<?= $value->id ?>" data-id_cliente="<?= $value->id_cliente ?>" data-estado="<?= $value->estado ?>">  <i class="bi bi-arrow-down-up"></i></button> 
											</div>
											<div class="ms-1">
												<a href="<?= base_url('imprimir/imprimir_nde/'. $value->id ) ?>" class="btn me-1" title="Imprimir Nota Entrega"><i class="bi bi-printer"></i></a>
											</div>
											<div class="ms-1">
												<a href="https://wa.me/<?= $cliente['telefono1'] ?>?text=*Nota Entrega%20<?= $value->id ?>%20Total:%20 <?= number_format($value->total_d, 2,",",".") ?>$ %20Detalles:%20<?= base_url('imprimir/imprimir_nde/'. $value->id ) ?>" class="btn btn-success" title="Enviar al Whatsapp"><i class="bi bi-whatsapp"></i></a>
											</div>


										</div>
									</div>
								</div>
						<?php } ?>

					</div>
				<?php	} ?>
			</div>
		<?php } ?>


		<!-- VENTAS CLIENTE MERCANCIAS -->
		
		<?php if ((isset($ventascliente)) && (!empty($cotizacionescliente))) { ?>
			<h6 class="mt-3">Ventas</h6>
			<hr class="m-1">
			<div class="row mt-2">
				<?php foreach ($ventascliente as $key => $value) { ?>
					<div class="card col-lg-4 col-12 p-2"  data-bs-toggle="collapse" data-bs-target="#collapseCotizacionDetalles<?= $key ?>" >
						<?php  if ($value->id_orden == null) { ?>

								<div class="d-flex justify-content-between align-items-center">
									<div class="">
										<span>Venta <?= $value->id ?></span>
										<span class="badge text-bg-<?php if ($value->estado == 'Aceptada') {
											echo 'success';}elseif ($value->estado == 'Aceptada') { echo 'danger' ;}else{echo 'light';} ?> ms-2"><?= $value->estado ?></span> <br>
										<span><small><?= $value->categoria ?></small></span>
									</div>
									
									<div class="text-end">
										<span>Total $ <?= $value->total_d ?></span><br>
										<span><small>Iva 16% <?= $value->iva ?></small></span>
									</div>
								</div>
								
								<div class="card p-2 collapse" id="collapseCotizacionDetalles<?= $key ?>">
										
									<div class="row">
										<?php if (isset($cotiarticuloscliente)) { 
											foreach ($cotiarticuloscliente as $key => $valuear) { ?>

											<?php  if ($valuear->id_cotizacion == $value->id) { ?>
											<div class="">
												<div class="d-flex justify-content-start px-2">
													<div><small><?= $valuear->descripcion ?></small></div>
													<div class="ms-auto"><small><?= $valuear->precio_d ?></small></div>
												</div>
											</div>
										<?php } } } ?>
									</div>

									<hr class="m-2">

									<div class="row">
										<div class="d-flex justify-content-between">
											<div>
			    								<a href="<?= base_url('nde/coti_nde_add/'. $value->id ) ?>" class="btn me-1" title="Enviar a Nota de Entrega"><i class="bi bi-clipboard-check"></i></a>
			    							</div>

			    							<div class="ms-auto">
												<button type="button" class="btn me-1" title="Cambiar Estado" onclick="editarCoti(this)" data-id="<?= $value->id ?>" data-id_cliente="<?= $value->id_cliente ?>" data-estado="<?= $value->estado ?>">  <i class="bi bi-arrow-down-up"></i></button> 
											</div>
											<div class="ms-1">
												<a href="<?= base_url('imprimir/imprimir_venta/'. $value->id ) ?>" class="btn me-1" title="Imprimir Venta"><i class="bi bi-printer"></i></a>
											</div>
											<div class="ms-1">
												<a href="https://wa.me/<?= $cliente['telefono1'] ?>?text=*Fectura%20<?= $value->id ?>%20Total:%20 <?= number_format($value->total_d, 2,",",".") ?>$ %20Detalles:%20<?= base_url('imprimir/imprimir_venta/'. $value->id ) ?>" class="btn btn-success" title="Enviar al Whatsapp"><i class="bi bi-whatsapp"></i></a>
											</div>


										</div>
									</div>
								</div>
						<?php } ?>

					</div>
				<?php	} ?>
			</div>
		<?php } ?>


		<!-- COMPRAS CLIENTE MERCANCIAS -->
		<?php if ((isset($comprascliente)) && (!empty($cotizacionescliente))) { ?>
			<h6 class="mt-3">Compras</h6>
			<hr class="m-1">
			<div class="row mt-2">
				<?php foreach ($comprascliente as $key => $value) { ?>
					<div class="card col-lg-4 col-12 p-2"  data-bs-toggle="collapse" data-bs-target="#collapseCotizacionDetalles<?= $key ?>" >
						<?php  if ($value->id_orden == null) { ?>

								<div class="d-flex justify-content-between align-items-center">
									<div class="">
										<span>Compra <?= $value->id ?></span>
										<span class="badge text-bg-<?php if ($value->estado == 'Aceptada') {
											echo 'success';}elseif ($value->estado == 'Aceptada') { echo 'danger' ;}else{echo 'light';} ?> ms-2"><?= $value->estado ?></span> <br>
										<span><small><?= $value->categoria ?></small></span>
									</div>
									
									<div class="text-end">
										<span>Total $ <?= $value->total_d ?></span><br>
										<span><small>Iva 16% <?= $value->iva ?></small></span>
									</div>
								</div>
								
								<div class="card p-2 collapse" id="collapseCotizacionDetalles<?= $key ?>">
										
									<div class="row">
										<?php if (isset($cotiarticuloscliente)) { 
											foreach ($cotiarticuloscliente as $key => $valuear) { ?>

											<?php  if ($valuear->id_cotizacion == $value->id) { ?>
											<div class="">
												<div class="d-flex justify-content-start px-2">
													<div><small><?= $valuear->descripcion ?></small></div>
													<div class="ms-auto"><small><?= $valuear->precio_d ?></small></div>
												</div>
											</div>
										<?php } } } ?>
									</div>

									<hr class="m-2">

									<div class="row">
										<div class="d-flex justify-content-between">
											<div>
			    								<a href="<?= base_url('nde/coti_nde_add/'. $value->id ) ?>" class="btn me-1" title="Enviar a Nota de Entrega"><i class="bi bi-clipboard-check"></i></a>
			    							</div>

			    							<div class="ms-auto">
												<button type="button" class="btn me-1" title="Cambiar Estado" onclick="editarCoti(this)" data-id="<?= $value->id ?>" data-id_cliente="<?= $value->id_cliente ?>" data-estado="<?= $value->estado ?>">  <i class="bi bi-arrow-down-up"></i></button> 
											</div>
											<div class="ms-1">
												<a href="<?= base_url('imprimir/imprimir_compra/'. $value->id ) ?>" class="btn me-1" title="Imprimir Compra"><i class="bi bi-printer"></i></a>
											</div>
											<div class="ms-1">
												<a href="https://wa.me/<?= $cliente['telefono1'] ?>?text=*Fectura%20<?= $value->id ?>%20Total:%20 <?= number_format($value->total_d, 2,",",".") ?>$ %20Detalles:%20<?= base_url('imprimir/imprimir_venta/'. $value->id ) ?>" class="btn btn-success" title="Enviar al Whatsapp"><i class="bi bi-whatsapp"></i></a>
											</div>


										</div>
									</div>
								</div>
						<?php } ?>

					</div>
				<?php	} ?>
			</div>
		<?php } ?>



		<!-- div modal_clientes_add -->
		<?= $this->include('clientes/modal_clientes_edit') ?>

		<!-- div modal_equipos_add   -->
		<?= $this->include('equipos/modal_equipos_add') ?>
		<!-- div modal_equipos_add   -->
		<?= $this->include('equipos/modal_equipos_edit') ?>

		<!-- div modal_ordenes_add   -->
		<?= $this->include('ordenes/modal_ordenes_add') ?>
		<!-- modal_ordenes_edit   -->
		<?= $this->include('ordenes/modal_ordenes_edit') ?>


		<!-- modal_cotizaciones_edit   -->
		<?= $this->include('cotizaciones/modal_cotizaciones_edit') ?>
		<!-- modal_cotizaciones_edit   -->
		<?= $this->include('nde/modal_nde_edit') ?>

	</div>

<?= $this->endSection() ?>


<!-- SCRIPTS -->
<?= $this->section("scripts") ?>
<?= $this->endSection() ?>