<?= $this->extend('layout/base_cliente') ?>
<!-- CONTENIDO -->
<?= $this->section("content") ?>
    <section class="reporte mt-4">
        <div class="container-lg">
            <div class="row mb-2">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <img src="<?php if (isset($dataConfig['logo'])) {echo base_url() ?>assets/epscolor/img/empresas/<?php echo $dataConfig['logo'] ; } ?>" alt="Logo" width="90">
                    </div>
                    <div><h5 id="html_documento"><?php if (isset($html_documento)) { echo $html_documento; } ?> <?php if (isset($post['id'])) {echo $post['id']; } ?></h5></div>
                </div>
            </div>
            
            <div class="row">
                <?php if(isset($cliente)) { ?>
                    <div class="col-lg-8 col-12 mb-1">
                        <div class="card p-2">
                            <div class="d-flex justify-content-between item-align-center">
                                    <div class="row">
                                        <?php if(isset($cliente['razonsocial'])) { ?> 
                                        <div class="" style="line-height: 1rem;"><?= $cliente['razonsocial'] ?> &nbsp&nbsp <small class="tel text-muted"><?= $cliente['rif'] ?></small></div>
                                        <?php } ?>
                                        
                                        <div class="" style="line-height: 1rem;">
                                            <?= $cliente['contacto'] ?> &nbsp&nbsp <small class="tel text-muted"><?= $cliente['telefono1'] ?></small><br>
                                        <small class="tel text-muted"><?= $cliente['direccion'] ?></small>
                                        </div>
                                    </div>
                                <div class="ms-auto"><i class="bi bi-people icon-25"></i></div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
            
            
            <div class="row">
                
                <!-- Table Articulos Reporte -->
                <div class="col-12">
                    <div class="card p-2 pb-0 mb-0">
                        <div class="">
                            <table class="table table-sm">
                               <thead>
                                  <tr>
                                     <th>id</th>
                                     <th>Descripcion</th>
                                     <th style="text-align: center">Cant.</th>
                                     <th style="text-align: right;">Precio</th>
                                     <th style="text-align: right">Subtotal</th>
                                  </tr>
                               </thead>
                            
                               <tbody>
                                  <?php foreach ($articulos as $row) { ?>
                                     <tr>
                                        <td><?php echo $row->id; ?></td>
                                        <td><?= $row->descripcion ?></td>
                                        <td style="text-align:center"><?= formato_numero($row->cantidad) ?></td>
                                        <td style="text-align:right"><?= formato_numero($row->precio_d) ?></td>
                                        <td style="text-align:right"><?= formato_numero($row->subtotal_d) ?></td>
                                     </tr>
                                  <?php } ?>
                               </tbody>
                            </table>
                        </div>
                    </div> 
                </div>
                
                <!-- Totales Articulos Reporte -->
                <div class="col-12">
                    <div class="card p-2">
                        <div class="">
                            <div class="row">
                                
                                <div class="col-lg-5 col-sm-6 col-12 order-lg-2 order-sm-2 order-1">
                                    <table class="table table-sm">
                                        <tr>
                                            <th style="width:50%">Subtotal</th>
                                            <td style="text-align: right"><?php if (isset($post['subtotal_d'])) {
                                            echo $post['subtotal_d'];
                                            } ?></td>
                                        </tr>
                                        <tr>
                                            <th>IVA 16%</th>
                                            <td style="text-align: right"><?php if (isset($post['iva'])) {
                                            echo formato_numero($post['iva']);
                                            } ?></td>
                                        </tr>
                                        <tr>
                                        <th>Total</th>
                                            <td style="text-align: right"><?php if (isset($post['total_d'])) {
                                            echo formato_numero($post['total_d']);
                                            } ?></td>
                                        </tr>
                    
                                    </table>
                                </div>
                                
                                <div class="col-lg-7 col-sm-6 col-12 order-lg-1 order-sm-1 order-2  ">
                                    <div class="card p-1">
                                        <small>
                                            <p class="text-muted well well-sm no-shadow" style="min-height: 30px;">
                                            <?php if (isset($post['notas'])) {
                                            echo "Monto expresado en dolares americanos ($).<br>";
                                            echo $post['notas'];
                                            } ?>
                                            </p>
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>    
                </div>
                
                
            </div>
            
            
            <div class="row">
                <div class="col-lg-12 p-1 ">
                    <p><small><?= pie_epscolor(); ?></small></p>
                    <p><small><?= cuenta_exterior(); ?></small></p>
                </div>
            </div>
            <div class="row d-print-none">
                <div class="col-lg-12">
                    <button type="button" class="btn btn-primary " onclick="window.print();"><i class="fa fa-print"></i> Imprimir Reporte</button>
                </div>
            </div>
        </div>
    </section>
<?= $this->endSection() ?>
<!-- SCRIPTS -->
<?= $this->section("scripts") ?>
<?= $this->endSection() ?>