jQuery(document).ready(function () {
	//FORMULARIOS ORDENES
	$("#form_add_ordenes").submit(function (e) {
		e.preventDefault();
		var f = $(this);
		var formData = new FormData(document.getElementById("form_add_ordenes"));
		$.ajax({
			url: base_url + "ordenes/add_ordenes",
			type: "POST",
			dataType: "JSON",
			data: formData,
			cache: false,
			contentType: false,
			processData: false,
			beforeSend: function () {
				$("#loader").removeClass("display-none");
			},
			success: function (r) {
        		//var r = JSON.parse(respuesta);
        		//console.log(r);
				//epsToast(color, text, icon, head, headsmall, mensaje, boton)
				epsToast(
					"light",
					"dark",
					'<i class="bi bi-check"></i>',
					"" + r.success,
					"" + r.data.id,
					"" ,
					"" + r.mensaje
					);
				$("#modal_ordenes_add").modal("hide");
				window.location.reload();
			},
			error: function (jqXHR, textStatus, error) {
				epsToast(
					"danger",
					"light",
					'<i class="bi bi-x-octagon"></i>',
					jqXHR,
					jqXHR.status,
					jqXHR.responseText,
					""
					);
				clearTimeout();
			},
			complete: function () {
				$("#loader").addClass("display-none");
        		//setTimeout(function(){ $('#loader').addClass('display-none'); }, 4000);
			},
		});
	});
	
	$("#form_edit_ordenes").submit(function (e) {
		e.preventDefault();
		var f = $(this);
		var formData = new FormData(document.getElementById("form_edit_ordenes"));
		$.ajax({
			url: base_url + "ordenes/edit_ordenes",
			type: "POST",
			dataType: "JSON",
			data: formData,
			cache: false,
			contentType: false,
			processData: false,
			beforeSend: function () {
				$("#loader").removeClass("display-none");
			},
			success: function (r) {
        		//var r = JSON.parse(respuesta);
        		//console.log(r);
				//epsToast(color, text, icon, head, headsmall, mensaje, boton)
				epsToast(
					"light",
					"dark",
					'<i class="bi bi-check"></i>',
					"" + r.success,
					"" + r.data.id,
					"" ,
					"" + r.mensaje
					);
				$("#modal_ordenes_edit").modal("hide");
				window.location.reload();
			},
			error: function (jqXHR, textStatus, error) {
				epsToast(
					"danger",
					"light",
					'<i class="bi bi-x-octagon"></i>',
					jqXHR,
					jqXHR.status,
					jqXHR.responseText,
					""
					);
				clearTimeout();
			},
			complete: function () {
				$("#loader").addClass("display-none");
        		//setTimeout(function(){ $('#loader').addClass('display-none'); }, 4000);
			},
		});
	});

	$("#form_add_informe_ordenes").submit(function (e) {
		e.preventDefault();
		var f = $(this);
		var formData = new FormData(document.getElementById("form_add_informe_ordenes"));
		$.ajax({
			url: base_url + "ordenes/add_informe_ordenes",
			type: "POST",
			dataType: "JSON",
			data: formData,
			cache: false,
			contentType: false,
			processData: false,
			beforeSend: function () {
				$("#loader").removeClass("display-none");
			},
			success: function (r) {
        		//var r = JSON.parse(respuesta);
        		//console.log(r);
				//epsToast(color, text, icon, head, headsmall, mensaje, boton)
				epsToast(
					"light",
					"dark",
					'<i class="bi bi-check"></i>',
					"" + r.success,
					"" + r.data.id,
					"" ,
					"" + r.mensaje
					);
				window.location.href = base_url + "ordenes/orden_show/" + r.data.id;
			},
			error: function (jqXHR, textStatus, error) {
				epsToast(
					"danger",
					"light",
					'<i class="bi bi-x-octagon"></i>',
					jqXHR,
					jqXHR.status,
					jqXHR.responseText,
					""
					);
				clearTimeout();
			},
			complete: function () {
				$("#loader").addClass("display-none");
        		//setTimeout(function(){ $('#loader').addClass('display-none'); }, 4000);
			},
		});
	});


	//BOTONES TABLA ORDENES
	$("#btn_tbl_ordenes_edit").click(function () {
		var resultJSON = $("#tbl_ordenes").bootstrapTable("getSelections");
		var seleccion = $('input[name="rtbl_ordenes"]:checked').length;
		if (seleccion == 0) {
			epsToast(
				"danger",
				"white",
				'<i class="bi bi-hdd"></i>',
				"Seleccion",
				"Error",
				"Seleccione un item de la tabla.",
				"bottom"
				);
			return false;
		} else {
			var ref = resultJSON[0]["id"];
			$("#modal_ordenes_edit").modal("show");

			fill_input_orden(resultJSON[0]);
		}
	});

	$("#btn_tbl_ordenes_cotizacion").click(function () {
		var resultJSON = $("#tbl_ordenes").bootstrapTable("getSelections");
		var seleccion = $('input[name="rtbl_ordenes"]:checked').length;
		if (seleccion == 0) {
			epsToast(
				"danger",
				"white",
				'<i class="bi bi-hdd"></i>',
				"Seleccion",
				"Error",
				"Seleccione un item de la tabla.",
				"bottom"
				);
			return false;
		} else {
			var ref = resultJSON[0]["id"];
			window.location.href = base_url + "cotizaciones/coti_add_id_orden/" + ref;
		}
	});

	$("#btn_tbl_ordenes_show").click(function () {
		var resultJSON = $("#tbl_ordenes").bootstrapTable("getSelections");
		var seleccion = $('input[name="rtbl_ordenes"]:checked').length;
		if (seleccion == 0) {
			epsToast(
				"danger",
				"white",
				'<i class="bi bi-hdd"></i>',
				"Seleccion",
				"Error",
				"Seleccione un item de la tabla.",
				"bottom"
				);
			return false;
		} else {
			var ref = resultJSON[0]["id"];
			window.location.href = base_url + "ordenes/orden_show/" + ref;
		}
	});
	
	$("#btn_ordenes_add_informe").click(function () {
		var resultJSON = $("#tbl_ordenes").bootstrapTable("getSelections");
		var seleccion = $('input[name="rtbl_ordenes"]:checked').length;
		if (seleccion == 0) {
			epsToast(
				"danger",
				"white",
				'<i class="bi bi-hdd"></i>',
				"Seleccion",
				"Error",
				"Seleccione un item de la tabla.",
				"bottom"
				);
			return false;
		} else {
			var ref = resultJSON[0]["id"];
			window.location.href = base_url + "ordenes/ordenes_add_informe/" + ref;
		}
	});

	
});


function crearOrden(orden) {
	let id_equipo = orden.getAttribute( "data-id");
	$('input[name="id_equipo"]').val(id_equipo);
	$("#modal_ordenes_add").modal("show");
}

function editarOrden(item) {
    console.log(item);
	
	$('input[name="id"]').val(item.id);
	$('input[name="id_orden"]').val(item.id);
	$('input[name="id_cliente"]').val(item.id_cliente);
	$('input[name="id_equipo"]').val(item.id_equipo);

	//$('input[name="tecnico"]').val(item.tecnico);
	$("#tecnico_edit").val(item.tecnico);
	$('input[name="fecha_visita"]').val(item.fecha_visita);
	$("#tipo_servicio_edit").val(item.tipo_servicio);
	$('input[name="falla_reportada"]').val(item.falla_reportada);
	$("#informe_edit").val(item.informe);
	$('input[name="estado"]').val(item.estado);

	if (item.completado === "1") { 
		document.getElementById("check_completado").checked = true;} 
		else { document.getElementById("check_completado").checked = false;}
	
	$("#modal_ordenes_edit").modal("show");
}

//FILL INPUT ORDEN
function fill_input_orden(data) {
	$('input[name="id_orden"]').val(data.id);
	$('input[name="id_cliente"]').val(data.id_cliente);
	$('input[name="id_equipo"]').val(data.id_equipo);
	$("#tipo_servicio").val(data.tipo_servicio);
	$("#tecnico").val(data.tecnico);
	$('input[name="fecha_visita"]').val(data.fecha_visita);
	$('input[name="falla_reportada"]').val(data.falla_reportada);
	$("#informe").val(data.informe);
	$('input[name="estado"]').val(data.estado);

	if (data.completado === "1") { 
		document.getElementById("check_completado").checked = true;} 
		else { document.getElementById("check_completado").checked = false;}
}